#ifdef	_SUN
#undef sun
#undef _SUN
#sun _SUN
#define WHOAMI		_SUN
#define DEFINES		-DCPPOPT=\"-D_SUN\",\"-D_BSD\" \
			-D_BSD -DINTSIGNAL -DCHARMALLOC
#define INCLUDES
#define LIBRARY
#define LIBRARIES
#define CCFLAGS
#define OBJECT(x)	x.o
#define AOUT(x)		x
#define	CC		cc
#define EXE(x)		-o x
#define ARC		arc
#endif

#ifdef	_PYR
#undef pyr
#undef _PYR
#pyr _PYR
#define WHOAMI		_PYR
#define DEFINES		-DCPPOPT=\"-D_PYR\",\"-D_BSD\" \
			-D_BSD -DINTSIGNAL -DCHARMALLOC
#define INCLUDES
#define LIBRARY
#define LIBRARIES
#define CCFLAGS		-gx
#define OBJECT(x)	x.o
#define AOUT(x)		x
#define	CC		cc
#define EXE(x)		-o x
#define ARC		arc
#endif

#ifdef	_MINIX
#undef _MINIX
#min _MINIX
#define WHOAMI		_MINIX
#define DEFINES		-DCPPOPT=\"-D_MINIX\",\"-D_V7\" \
			-D_MINIX -DINTSIGNAL -DCHARMALLOC
#define LIBRARY
#define LIBRARIES
#define INCLUDES
#define CCFLAGS
#define OBJECT(x)	x.s
#define AOUT(x)		x
#define	CC		cc
#define EXE(x)		-o x
#define ARC		arc
#endif

#ifdef	_MSDOS
#undef _MSDOS
#dos _MSDOS
#define WHOAMI		_MSDOS
#define DEFINES		-DCPPOPT="-D_MSDOS" -D_MSDOS
#define LIBRARY		-Lc:/tc/usr/lib;c:/tc/lib
#define LIBRARIES	libcs.lib
#define INCLUDES	-Ic:/tc/usr/include;c:/tc/include
#define CCFLAGS		-A -w
#define OBJECT(x)	x.obj
#define AOUT(x)		x.exe
#define	CC		tcc
#define EXE(x)		-e##x
#define ARC		pkarc
#endif

#define NONAME
#define NAME	cppmake

define= DEFINES
include= INCLUDES
library= LIBRARY
all= *.c test.* makefile.* *.man *.doc

everyone= sun pyr min dos

CFLAGS= $(define) $(include) CCFLAGS

LFLAGS= $(library)

source= cppmake.c
object= OBJECT(cppmake)
libraries= LIBRARIES

.SUFFIXES:	OBJECT(NONAME) .c

.c##OBJECT(NONAME):
	CC -c $(CFLAGS) $<

AOUT(cppmake):	$(object)
	CC EXE(cppmake) $(LFLAGS) OBJECT(cppmake) $(libraries)

$(object):

# Everything

all:	cppmake.doc AOUT(cppmake)

# Documentation

NAME.doc:	NAME.man
	nroff -man NAME.man | col -b > NAME.doc

# Lint checking

lint:
	lint $(define) $(source)

# Test

test:
	( cppmake -v -f test.cpp 2>&1 ) | more

# Packing

arc:
	rm -f NAME.arc
	ARC a NAME.arc $(all)

# Makefiles

makefiles:
	-for w in $(everyone) ; \
	do \
	n=`awk "/^#$$w / "'{ print $$2 }' <CPPMAKEFILE` ; \
	if test WHOAMI = $$n ; then \
	cppmake -o makefile.$$w ; \
	else \
	cppmake -U##WHOAMI -D$$n -o makefile.$$w ; \
	fi ; \
	done

# Shell Archive
shar:
	ls $(all) | \
	sed -e 's/^.*\.doc/&	Formatted documentation/' \
	    -e 's/^.*\.man/&	Manual page source/' \
	    -e 's/^test\.cpp$$/&	Test file/' \
	    -e 's/^makefile\.cpp$$/&	Cppmakefile/' \
	    -e 's/^makefile\.[a-z]*$$/&	Site dependent makefiles/' \
	    -e 's/^.*\.c$$/&	Source code/' | \
	makekit -n##NAME. -s30k -oMANIFEST
