/* Function prototypes. */

struct mproc;		/* need types outside of parameter list --kub */
struct stat;

/* alloc.c */
_PROTOTYPE( phys_clicks alloc_mem, (phys_clicks clicks)			);
_PROTOTYPE( void free_mem, (phys_clicks base, phys_clicks clicks)	);
_PROTOTYPE( phys_clicks max_hole, (void)				);
_PROTOTYPE( void mem_init, (void)					);
_PROTOTYPE( phys_clicks mem_left, (void)				);

/* amoeba.c */
#if AM_KERNEL
_PROTOTYPE( int do_amoeba, (void)					);
#endif

/* break.c */
_PROTOTYPE( int adjust, (struct mproc *rmp,
			vir_clicks data_clicks, vir_bytes sp)		);
_PROTOTYPE( int do_brk, (void)						);
_PROTOTYPE( int size_ok, (int file_type, vir_clicks tc, vir_clicks dc,
			vir_clicks sc, vir_clicks dvir, vir_clicks s_vir) );
_PROTOTYPE( void stack_fault, (int proc_nr)				);

/* exec.c */
_PROTOTYPE( int do_exec, (void)						);

/* forkexit.c */
_PROTOTYPE( int do_fork, (void)						);
_PROTOTYPE( int do_mm_exit, (void)					);
_PROTOTYPE( int do_wait, (void)						);
_PROTOTYPE( void mm_exit, (struct mproc *rmp, int exit_status)		);

/* getset.c */
_PROTOTYPE( int do_getset, (void)					);

/* main.c */
_PROTOTYPE( int do_brk2, (void)						);
_PROTOTYPE( phys_clicks get_mem, (phys_clicks *pbase, int extflag)	);
#if (MACHINE == MACINTOSH)
_PROTOTYPE( phys_clicks start_click, (void)				);
#endif
_PROTOTYPE( void main, (void)						);
_PROTOTYPE( void reply, (int proc_nr, int result, int res2, char *respt));

/* putc.c */
_PROTOTYPE( void putc, (int c)						);

/* signal.c */
_PROTOTYPE( int do_alarm, (void)					);
_PROTOTYPE( int do_kill, (void)						);
_PROTOTYPE( int do_ksig, (void)						);
_PROTOTYPE( int do_pause, (void)					);
_PROTOTYPE( int do_signal, (void)					);
_PROTOTYPE( int set_alarm, (int proc_nr, unsigned sec)			);
_PROTOTYPE( void sig_proc, (struct mproc *rmp, int sig_nr)		);

/* trace.c */
_PROTOTYPE( int do_trace, (void)					);
_PROTOTYPE( void stop_proc, (struct mproc *rmp, int sig_nr)		);

/* utility.c */
_PROTOTYPE( int allowed, (char *name_buf, struct stat *s_buf, int mask)	);
_PROTOTYPE( int mem_copy, (int src_proc, int src_seg, long src_vir, 
		   int dst_proc, int dst_seg, long dst_vir, long bytes) );
_PROTOTYPE( int no_sys, (void)						);
_PROTOTYPE( void panic, (char *format, int num)				);

/* library */
_PROTOTYPE( int close, (int _fd)					);
_PROTOTYPE( int creat, (const char *_path, /* mode_t */ unsigned _mode)	);
_PROTOTYPE( int fstat, (int fd, struct stat *buffer)			);
_PROTOTYPE( off_t lseek, (int _fd, off_t _offset, int _whence)		);
_PROTOTYPE( int open,  (const char *_path, int _oflag, ...) 		);
_PROTOTYPE( void printk, (char *_fmt, ...)				);
_PROTOTYPE( int read, (int _fd, char *_buf, unsigned int _n)		);
_PROTOTYPE( int receive, (int _src, message *_m_ptr)			);
_PROTOTYPE( int send, (int _dest, message *_m_ptr)			);
_PROTOTYPE( int sendrec, (int _src_dest, message *_m_ptr)		);
_PROTOTYPE( int write, (int _fd, char *_buf, unsigned int _n)		);

_PROTOTYPE( void sys_abort, (void)					);
_PROTOTYPE( void sys_copy, (message *mptr)				);
_PROTOTYPE( void sys_exec, (int proc, char *ptr, int traced)		);
_PROTOTYPE( void sys_getsp, (int proc, vir_bytes *newsp)		);
_PROTOTYPE( void sys_newmap, (int proc, char *ptr)			);
_PROTOTYPE( void sys_sig, (int proc, int sig, void (*sighandler)())	);
_PROTOTYPE( int sys_trace,(int req, int procnr, long addr, long *data_p));
_PROTOTYPE( void tell_fs, (int what, int p1, int p2, int p3)		);
#if (CHIP == M68000)
_PROTOTYPE( void sys_fork, (int parent, int child, int pid,
			phys_clicks shadow)				);
_PROTOTYPE( void sys_fresh, (int proc, char *ptr, phys_clicks dc,
			phys_clicks *basep, phys_clicks *sizep)		);
_PROTOTYPE( void sys_xit, (int parent, int proc,
			phys_clicks *basep, phys_clicks *sizep)		);
#else
_PROTOTYPE( void sys_fork, (int parent, int child, int pid)		);
_PROTOTYPE( void sys_xit, (int parent, int proc)			);
#endif
