/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.ExprValue;
import tcl.lang.Interp;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.UnaryMathFunction;

class TanhFunction
extends UnaryMathFunction {
    ExprValue apply(Interp interp, TclObject[] tclObjectArray) throws TclException {
        double d = TclDouble.get(interp, tclObjectArray[0]);
        if (d == 0.0) {
            return new ExprValue(0.0);
        }
        double d2 = Math.pow(Math.E, d);
        double d3 = Math.pow(Math.E, -d);
        if (d2 == Double.NaN || d2 == Double.NEGATIVE_INFINITY || d2 == Double.POSITIVE_INFINITY) {
            interp.setErrorCode(TclString.newInstance("ARITH OVERFLOW {floating-point value too large to represent}"));
            throw new TclException(interp, "floating-point value too large to represent");
        }
        if (d3 == Double.NaN || d3 == Double.NEGATIVE_INFINITY || d3 == Double.POSITIVE_INFINITY) {
            interp.setErrorCode(TclString.newInstance("ARITH OVERFLOW {floating-point value too large to represent}"));
            throw new TclException(interp, "floating-point value too large to represent");
        }
        return new ExprValue((d2 - d3) / (d2 + d3));
    }

    TanhFunction() {
    }
}

