/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.ExprValue;
import tcl.lang.Interp;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.UnaryMathFunction;

class ExpFunction
extends UnaryMathFunction {
    ExprValue apply(Interp interp, TclObject[] tclObjectArray) throws TclException {
        double d = Math.exp(TclDouble.get(interp, tclObjectArray[0]));
        if (d == Double.NaN || d == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY) {
            interp.setErrorCode(TclString.newInstance((String)"ARITH OVERFLOW {floating-point value too large to represent}"));
            throw new TclException(interp, "floating-point value too large to represent");
        }
        return new ExprValue(d);
    }

    ExpFunction() {
    }
}

