/*
 * SayhelloCmd.java
 *
 * Copyright (c) 1997 Sun Microsystems, Inc.
 *
 *   This file implements the SayhelloCmd class.
 *
 * See the file "license.terms" for information on usage and
 * redistribution of this file, and for a DISCLAIMER OF ALL
 * WARRANTIES.
 *
 * SCCS: @(#) SayhelloCmd.java 1.4 97/10/10 16:09:07
 */

import tcl.lang.*;

/*
 * This class implements the "sayhello" command in SimplePackage.
 */

class SayhelloCmd implements Command {
    /*
     * This procedure is invoked to process the "sayhello" Tcl command
     * -- it takes no arguments and returns "Hello World!" string as
     * its result.
     */

    public void cmdProc(Interp interp, TclObject argv[])
	    throws TclException {
	if (argv.length != 1) {
	    throw new TclNumArgsException(interp, 1, argv, "");
	}
	interp.setResult("Hello World!");
    }
}
