/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import tcl.lang.ClockRelTimespan;
import tcl.lang.ClockToken;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclBoolean;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

class ClockCmd
implements Command {
    private static final String[] validCmds = new String[]{"clicks", "format", "scan", "seconds"};
    private static final int CMD_CLICKS = 0;
    private static final int CMD_FORMAT = 1;
    private static final int CMD_SCAN = 2;
    private static final int CMD_SECONDS = 3;
    private static final String[] formatOpts = new String[]{"-format", "-gmt"};
    private static final int OPT_FORMAT_FORMAT = 0;
    private static final int OPT_FORMAT_GMT = 1;
    private static final String[] scanOpts = new String[]{"-base", "-gmt"};
    private static final int OPT_SCAN_BASE = 0;
    private static final int OPT_SCAN_GMT = 1;
    static final int EPOCH_YEAR = 1970;

    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        String string = null;
        boolean bl = false;
        TclObject tclObject = null;
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "option ?arg ...?");
        }
        int n = TclIndex.get((Interp)interp, (TclObject)tclObjectArray[1], (String[])validCmds, (String)"option", (int)0);
        switch (n) {
            case 0: {
                if (tclObjectArray.length != 2) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, null);
                }
                long l = System.currentTimeMillis();
                int n2 = (int)(l % Integer.MAX_VALUE);
                interp.setResult(TclInteger.newInstance((int)n2));
                return;
            }
            case 1: {
                if (tclObjectArray.length < 3 || tclObjectArray.length > 7) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "clockval ?-format string? ?-gmt boolean?");
                }
                int n3 = TclInteger.get((Interp)interp, (TclObject)tclObjectArray[2]);
                int n4 = 3;
                while (n4 + 1 < tclObjectArray.length) {
                    int n5 = TclIndex.get((Interp)interp, (TclObject)tclObjectArray[n4], (String[])formatOpts, (String)"switch", (int)0);
                    switch (n5) {
                        case 0: {
                            string = tclObjectArray[n4 + 1].toString();
                            break;
                        }
                        case 1: {
                            bl = TclBoolean.get((Interp)interp, (TclObject)tclObjectArray[n4 + 1]);
                        }
                    }
                    n4 += 2;
                }
                if (n4 < tclObjectArray.length) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "clockval ?-format string? ?-gmt boolean?");
                }
                this.FormatClock(interp, n3, bl, string);
                return;
            }
            case 2: {
                Date date;
                if (tclObjectArray.length < 3 || tclObjectArray.length > 7) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "dateString ?-base clockValue? ?-gmt boolean?");
                }
                String string2 = tclObjectArray[2].toString();
                int n6 = 3;
                while (n6 + 1 < tclObjectArray.length) {
                    int n7 = TclIndex.get((Interp)interp, (TclObject)tclObjectArray[n6], (String[])scanOpts, (String)"switch", (int)0);
                    switch (n7) {
                        case 0: {
                            tclObject = tclObjectArray[n6 + 1];
                            break;
                        }
                        case 1: {
                            bl = TclBoolean.get((Interp)interp, (TclObject)tclObjectArray[n6 + 1]);
                        }
                    }
                    n6 += 2;
                }
                if (n6 < tclObjectArray.length) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "clockval ?-format string? ?-gmt boolean?");
                }
                if (tclObject != null) {
                    long l = TclInteger.get((Interp)interp, tclObject);
                    date = new Date(l * 1000L);
                } else {
                    date = new Date();
                }
                Date date2 = this.GetDate(string2, date, bl);
                if (date2 == null) {
                    throw new TclException(interp, "unable to convert date-time string \"" + string2 + "\"");
                }
                int n8 = (int)(date2.getTime() / 1000L);
                interp.setResult(TclInteger.newInstance((int)n8));
                return;
            }
            case 3: {
                if (tclObjectArray.length != 2) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, null);
                }
                long l = System.currentTimeMillis();
                int n9 = (int)(l / 1000L);
                interp.setResult(TclInteger.newInstance((int)n9));
                return;
            }
        }
    }

    private void FormatClock(Interp interp, int n, boolean bl, String string) throws TclException {
        Date date = new Date((long)n * 1000L);
        Calendar calendar = Calendar.getInstance();
        FieldPosition fieldPosition = new FieldPosition(0);
        if (string == null) {
            string = new String("%a %b %d %H:%M:%S %Z %Y");
        }
        calendar.setTime(date);
        if (bl) {
            calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("mm.dd.yy", Locale.US);
        simpleDateFormat.setCalendar(calendar);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == '%' && n2 + 1 < string.length()) {
                switch (string.charAt(++n2)) {
                    case '%': {
                        stringBuffer.append('%');
                        break;
                    }
                    case 'a': {
                        simpleDateFormat.applyPattern("EEE");
                        simpleDateFormat.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 'A': {
                        simpleDateFormat.applyPattern("EEEE");
                        simpleDateFormat.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 'b': 
                    case 'h': {
                        simpleDateFormat.applyPattern("MMM");
                        simpleDateFormat.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 'B': {
                        simpleDateFormat.applyPattern("MMMM");
                        simpleDateFormat.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 'c': {
                        SimpleDateFormat simpleDateFormat2 = (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 3);
                        simpleDateFormat2.setCalendar(calendar);
                        simpleDateFormat2.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 'C': {
                        int n3 = calendar.get(1) / 100;
                        stringBuffer.append(String.valueOf(n3 < 10 ? "0" : "") + n3);
                        break;
                    }
                    case 'd': {
                        simpleDateFormat.applyPattern("dd");
                        simpleDateFormat.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 'D': {
                        simpleDateFormat.applyPattern("MM/dd/yy");
                        simpleDateFormat.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 'e': {
                        simpleDateFormat.applyPattern("d");
                        String string2 = simpleDateFormat.format(date);
                        stringBuffer.append(String.valueOf(string2.length() < 2 ? " " : "") + string2);
                        break;
                    }
                    case 'H': {
                        simpleDateFormat.applyPattern("HH");
                        simpleDateFormat.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 'I': {
                        simpleDateFormat.applyPattern("hh");
                        simpleDateFormat.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 'j': {
                        simpleDateFormat.applyPattern("DDD");
                        simpleDateFormat.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 'k': {
                        simpleDateFormat.applyPattern("H");
                        String string3 = simpleDateFormat.format(date);
                        stringBuffer.append(String.valueOf(string3.length() < 2 ? " " : "") + string3);
                        break;
                    }
                    case 'l': {
                        simpleDateFormat.applyPattern("h");
                        String string4 = simpleDateFormat.format(date);
                        stringBuffer.append(String.valueOf(string4.length() < 2 ? " " : "") + string4);
                        break;
                    }
                    case 'm': {
                        simpleDateFormat.applyPattern("MM");
                        simpleDateFormat.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 'M': {
                        simpleDateFormat.applyPattern("mm");
                        simpleDateFormat.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 'n': {
                        stringBuffer.append('\n');
                        break;
                    }
                    case 'p': {
                        simpleDateFormat.applyPattern("aa");
                        simpleDateFormat.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 'r': {
                        simpleDateFormat.applyPattern("KK:mm:ss aaaa");
                        simpleDateFormat.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 'R': {
                        simpleDateFormat.applyPattern("hh:mm");
                        simpleDateFormat.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 's': {
                        long l = calendar.getTime().getTime();
                        if (bl) {
                            Calendar calendar2 = Calendar.getInstance();
                            calendar2.setTime(calendar.getTime());
                            l -= (long)(calendar2.get(15) + calendar2.get(16));
                        }
                        stringBuffer.append((int)(l / 1000L));
                        break;
                    }
                    case 'S': {
                        simpleDateFormat.applyPattern("ss");
                        simpleDateFormat.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 't': {
                        stringBuffer.append('\t');
                        break;
                    }
                    case 'T': {
                        simpleDateFormat.applyPattern("hh:mm:ss");
                        simpleDateFormat.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 'u': {
                        int n4 = calendar.get(7);
                        if (n4 == 1) {
                            stringBuffer.append(7);
                            break;
                        }
                        stringBuffer.append(n4 - 1);
                        break;
                    }
                    case 'U': {
                        int n5 = this.GetWeek(calendar, 1, false);
                        stringBuffer.append(String.valueOf(n5 < 10 ? "0" : "") + n5);
                        break;
                    }
                    case 'V': {
                        int n6 = this.GetWeek(calendar, 2, true);
                        stringBuffer.append(String.valueOf(n6 < 10 ? "0" : "") + n6);
                        break;
                    }
                    case 'w': {
                        int n7 = calendar.get(7);
                        stringBuffer.append(n7 - 1);
                        break;
                    }
                    case 'W': {
                        int n8 = this.GetWeek(calendar, 2, false);
                        stringBuffer.append(String.valueOf(n8 < 10 ? "0" : "") + n8);
                        break;
                    }
                    case 'x': {
                        SimpleDateFormat simpleDateFormat2 = (SimpleDateFormat)DateFormat.getDateInstance(3);
                        simpleDateFormat2.setCalendar(calendar);
                        simpleDateFormat2.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 'X': {
                        SimpleDateFormat simpleDateFormat2 = (SimpleDateFormat)DateFormat.getTimeInstance(3);
                        simpleDateFormat2.setCalendar(calendar);
                        simpleDateFormat2.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 'y': {
                        simpleDateFormat.applyPattern("yy");
                        simpleDateFormat.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 'Y': {
                        simpleDateFormat.applyPattern("yyyy");
                        simpleDateFormat.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    case 'Z': {
                        simpleDateFormat.applyPattern("zzz");
                        simpleDateFormat.format(date, stringBuffer, fieldPosition);
                        break;
                    }
                    default: {
                        stringBuffer.append(string.charAt(n2));
                        break;
                    }
                }
            } else {
                stringBuffer.append(string.charAt(n2));
            }
            ++n2;
        }
        String string5 = stringBuffer.toString();
        if (string5 == null) {
            interp.resetResult();
            return;
        }
        interp.setResult(TclString.newInstance((String)string5));
    }

    private int GetWeek(Calendar calendar, int n, boolean bl) {
        if (bl) {
            n = 2;
        }
        calendar.setFirstDayOfWeek(n);
        calendar.setMinimalDaysInFirstWeek(bl ? 4 : 7);
        calendar.setTime(calendar.getTime());
        int n2 = calendar.get(3);
        if (!bl && calendar.get(2) == 0 && n2 > 50) {
            n2 = 0;
        }
        return n2;
    }

    private void SetWeekday(Calendar calendar, ClockRelTimespan clockRelTimespan) {
        int n = clockRelTimespan.getWeekday();
        int n2 = clockRelTimespan.getDayOrdinal();
        while (calendar.get(7) != n) {
            calendar.add(5, 1);
        }
        if (n2 > 1) {
            calendar.add(5, 7 * (n2 - 1));
        }
    }

    private Date GetDate(String string, Date date, boolean bl) {
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date);
        calendar.set(calendar2.get(1), calendar2.get(2), calendar2.get(5), 0, 0, 0);
        if (bl) {
            calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        ClockToken[] clockTokenArray = this.GetTokens(string, false);
        ParsePosition parsePosition = new ParsePosition(0);
        ClockRelTimespan clockRelTimespan = new ClockRelTimespan();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (parsePosition.getIndex() < clockTokenArray.length) {
            if (this.ParseTime(clockTokenArray, parsePosition, calendar)) {
                ++n;
                continue;
            }
            if (this.ParseZone(clockTokenArray, parsePosition, calendar)) {
                ++n2;
                continue;
            }
            if (this.ParseDate(clockTokenArray, parsePosition, calendar)) {
                ++n3;
                continue;
            }
            if (this.ParseDay(clockTokenArray, parsePosition, clockRelTimespan)) {
                ++n4;
                continue;
            }
            if (this.ParseRel(clockTokenArray, parsePosition, clockRelTimespan)) {
                ++n5;
                continue;
            }
            if (this.ParseNumber(clockTokenArray, parsePosition, calendar, n3 > 0 && n > 0 && n5 == 0)) {
                if (n3 != 0 && n != 0 && n5 <= 0) continue;
                ++n;
                continue;
            }
            return null;
        }
        if (n > 1 || n2 > 1 || n3 > 1 || n4 > 1) {
            return null;
        }
        int n6 = calendar.get(1);
        if (n6 < 100) {
            if (n6 >= 69) {
                calendar.set(1, n6 + 1900);
            } else {
                calendar.set(1, n6 + 2000);
            }
        }
        if (n5 > 0) {
            if (n == 0 && n3 == 0 && n4 == 0) {
                calendar.setTime(date);
            }
            calendar.add(13, clockRelTimespan.getSeconds());
            calendar.add(2, clockRelTimespan.getMonths());
        }
        if (n4 > 0 && n3 == 0) {
            this.SetWeekday(calendar, clockRelTimespan);
        }
        return calendar.getTime();
    }

    private boolean ParseTime(ClockToken[] clockTokenArray, ParsePosition parsePosition, Calendar calendar) {
        int n = parsePosition.getIndex();
        if (n + 5 < clockTokenArray.length && clockTokenArray[n].isUNumber() && clockTokenArray[n + 1].is(':') && clockTokenArray[n + 2].isUNumber() && clockTokenArray[n + 3].is(':') && clockTokenArray[n + 4].isUNumber() && clockTokenArray[n + 5].isSNumber()) {
            calendar.set(10, clockTokenArray[n].getInt());
            calendar.set(12, clockTokenArray[n + 2].getInt());
            calendar.set(13, clockTokenArray[n + 4].getInt());
            parsePosition.setIndex(n + 6);
            return true;
        }
        if (n + 4 < clockTokenArray.length && clockTokenArray[n].isUNumber() && clockTokenArray[n + 1].is(':') && clockTokenArray[n + 2].isUNumber() && clockTokenArray[n + 3].is(':') && clockTokenArray[n + 4].isUNumber()) {
            parsePosition.setIndex(n + 5);
            this.ParseMeridianAndSetHour(clockTokenArray, parsePosition, calendar, clockTokenArray[n].getInt());
            calendar.set(12, clockTokenArray[n + 2].getInt());
            calendar.set(13, clockTokenArray[n + 4].getInt());
            return true;
        }
        if (n + 3 < clockTokenArray.length && clockTokenArray[n].isUNumber() && clockTokenArray[n + 1].is(':') && clockTokenArray[n + 2].isUNumber() && clockTokenArray[n + 3].isSNumber()) {
            calendar.set(10, clockTokenArray[n].getInt());
            calendar.set(12, clockTokenArray[n + 2].getInt());
            parsePosition.setIndex(n + 4);
            return true;
        }
        if (n + 2 < clockTokenArray.length && clockTokenArray[n].isUNumber() && clockTokenArray[n + 1].is(':') && clockTokenArray[n + 2].isUNumber()) {
            parsePosition.setIndex(n + 3);
            this.ParseMeridianAndSetHour(clockTokenArray, parsePosition, calendar, clockTokenArray[n].getInt());
            calendar.set(12, clockTokenArray[n + 2].getInt());
            return true;
        }
        if (n + 1 < clockTokenArray.length && clockTokenArray[n].isUNumber() && clockTokenArray[n + 1].is(15)) {
            parsePosition.setIndex(n + 1);
            this.ParseMeridianAndSetHour(clockTokenArray, parsePosition, calendar, clockTokenArray[n].getInt());
            return true;
        }
        return false;
    }

    private boolean ParseZone(ClockToken[] clockTokenArray, ParsePosition parsePosition, Calendar calendar) {
        int n = parsePosition.getIndex();
        if (n + 1 < clockTokenArray.length && clockTokenArray[n].is(12) && clockTokenArray[n + 1].is(14)) {
            calendar.setTimeZone(clockTokenArray[n].getZone());
            parsePosition.setIndex(n + 2);
            return true;
        }
        if (n < clockTokenArray.length && clockTokenArray[n].is(12)) {
            calendar.setTimeZone(clockTokenArray[n].getZone());
            parsePosition.setIndex(n + 1);
            return true;
        }
        if (n < clockTokenArray.length && clockTokenArray[n].is(13)) {
            calendar.setTimeZone(clockTokenArray[n].getZone());
            parsePosition.setIndex(n + 1);
            return true;
        }
        return false;
    }

    private boolean ParseDay(ClockToken[] clockTokenArray, ParsePosition parsePosition, ClockRelTimespan clockRelTimespan) {
        int n = parsePosition.getIndex();
        if (n + 1 < clockTokenArray.length && clockTokenArray[n].is(6) && clockTokenArray[n + 1].is(',')) {
            clockRelTimespan.setWeekday(clockTokenArray[n].getInt());
            parsePosition.setIndex(n + 2);
            return true;
        }
        if (n + 1 < clockTokenArray.length && clockTokenArray[n].isUNumber() && clockTokenArray[n + 1].is(6)) {
            clockRelTimespan.setWeekday(clockTokenArray[n + 1].getInt(), clockTokenArray[n].getInt());
            parsePosition.setIndex(n + 2);
            return true;
        }
        if (n < clockTokenArray.length && clockTokenArray[n].is(6)) {
            clockRelTimespan.setWeekday(clockTokenArray[n].getInt());
            parsePosition.setIndex(n + 1);
            return true;
        }
        return false;
    }

    private boolean ParseDate(ClockToken[] clockTokenArray, ParsePosition parsePosition, Calendar calendar) {
        int n = parsePosition.getIndex();
        if (n + 4 < clockTokenArray.length && clockTokenArray[n].isUNumber() && clockTokenArray[n + 1].is('/') && clockTokenArray[n + 2].isUNumber() && clockTokenArray[n + 3].is('/') && clockTokenArray[n + 4].isUNumber()) {
            calendar.set(5, clockTokenArray[n + 2].getInt());
            calendar.set(2, clockTokenArray[n].getInt() - 1);
            calendar.set(1, clockTokenArray[n + 4].getInt());
            parsePosition.setIndex(n + 5);
            return true;
        }
        if (n + 3 < clockTokenArray.length && clockTokenArray[n].is(5) && clockTokenArray[n + 1].isUNumber() && clockTokenArray[n + 2].is(',') && clockTokenArray[n + 3].isUNumber()) {
            calendar.set(5, clockTokenArray[n + 1].getInt());
            calendar.set(2, clockTokenArray[n].getInt());
            calendar.set(1, clockTokenArray[n + 3].getInt());
            parsePosition.setIndex(n + 4);
            return true;
        }
        if (n + 2 < clockTokenArray.length && clockTokenArray[n].isUNumber() && clockTokenArray[n + 1].is('/') && clockTokenArray[n + 2].isUNumber()) {
            calendar.set(5, clockTokenArray[n + 2].getInt());
            calendar.set(2, clockTokenArray[n].getInt() - 1);
            parsePosition.setIndex(n + 3);
            return true;
        }
        if (n + 2 < clockTokenArray.length && clockTokenArray[n].isUNumber() && clockTokenArray[n + 1].is(5) && clockTokenArray[n + 2].isUNumber()) {
            calendar.set(5, clockTokenArray[n].getInt());
            calendar.set(2, clockTokenArray[n + 1].getInt());
            calendar.set(1, clockTokenArray[n + 2].getInt());
            parsePosition.setIndex(n + 3);
            return true;
        }
        if (n + 1 < clockTokenArray.length && clockTokenArray[n].is(5) && clockTokenArray[n + 1].isUNumber()) {
            calendar.set(5, clockTokenArray[n + 1].getInt());
            calendar.set(2, clockTokenArray[n].getInt());
            parsePosition.setIndex(n + 2);
            return true;
        }
        if (n + 1 < clockTokenArray.length && clockTokenArray[n].isUNumber() && clockTokenArray[n + 1].is(5)) {
            calendar.set(5, clockTokenArray[n].getInt());
            calendar.set(2, clockTokenArray[n + 1].getInt());
            parsePosition.setIndex(n + 2);
            return true;
        }
        if (n < clockTokenArray.length && clockTokenArray[n].is(11)) {
            calendar.set(5, 1);
            calendar.set(2, 0);
            calendar.set(1, 1970);
            parsePosition.setIndex(n + 1);
            return true;
        }
        return false;
    }

    private boolean ParseNumber(ClockToken[] clockTokenArray, ParsePosition parsePosition, Calendar calendar, boolean bl) {
        int n = parsePosition.getIndex();
        if (n < clockTokenArray.length && clockTokenArray[n].isUNumber()) {
            parsePosition.setIndex(n + 1);
            if (bl) {
                calendar.set(1, clockTokenArray[n].getInt());
            } else {
                calendar.set(11, clockTokenArray[n].getInt() / 100);
                calendar.set(12, clockTokenArray[n].getInt() % 100);
                calendar.set(13, 0);
            }
            return true;
        }
        return false;
    }

    private boolean ParseRel(ClockToken[] clockTokenArray, ParsePosition parsePosition, ClockRelTimespan clockRelTimespan) {
        if (this.ParseRelUnit(clockTokenArray, parsePosition, clockRelTimespan)) {
            int n = parsePosition.getIndex();
            if (n < clockTokenArray.length && clockTokenArray[n].is(10)) {
                clockRelTimespan.negate();
                parsePosition.setIndex(n + 1);
            }
            return true;
        }
        return false;
    }

    private boolean ParseRelUnit(ClockToken[] clockTokenArray, ParsePosition parsePosition, ClockRelTimespan clockRelTimespan) {
        int n = parsePosition.getIndex();
        if (n + 1 < clockTokenArray.length && (clockTokenArray[n].isUNumber() || clockTokenArray[n].isSNumber()) && clockTokenArray[n + 1].is(8)) {
            clockRelTimespan.addSeconds(clockTokenArray[n].getInt() * clockTokenArray[n + 1].getInt() * 60);
            parsePosition.setIndex(n + 2);
            return true;
        }
        if (n + 1 < clockTokenArray.length && (clockTokenArray[n].isUNumber() || clockTokenArray[n].isSNumber()) && clockTokenArray[n + 1].is(9)) {
            clockRelTimespan.addSeconds(clockTokenArray[n].getInt());
            parsePosition.setIndex(n + 2);
            return true;
        }
        if (n + 1 < clockTokenArray.length && (clockTokenArray[n].isUNumber() || clockTokenArray[n].isSNumber()) && clockTokenArray[n + 1].is(7)) {
            clockRelTimespan.addMonths(clockTokenArray[n].getInt() * clockTokenArray[n + 1].getInt());
            parsePosition.setIndex(n + 2);
            return true;
        }
        if (n < clockTokenArray.length && clockTokenArray[n].is(8)) {
            clockRelTimespan.addSeconds(clockTokenArray[n].getInt() * 60);
            parsePosition.setIndex(n + 1);
            return true;
        }
        if (n < clockTokenArray.length && clockTokenArray[n].is(9)) {
            clockRelTimespan.addSeconds(1);
            parsePosition.setIndex(n + 1);
            return true;
        }
        if (n < clockTokenArray.length && clockTokenArray[n].is(7)) {
            clockRelTimespan.addMonths(clockTokenArray[n].getInt());
            parsePosition.setIndex(n + 1);
            return true;
        }
        return false;
    }

    private void ParseMeridianAndSetHour(ClockToken[] clockTokenArray, ParsePosition parsePosition, Calendar calendar, int n) {
        int n2;
        int n3 = parsePosition.getIndex();
        if (n3 < clockTokenArray.length && clockTokenArray[n3].is(15)) {
            calendar.set(9, clockTokenArray[n3].getInt());
            parsePosition.setIndex(n3 + 1);
            n2 = 10;
        } else {
            n2 = 11;
        }
        if (n2 == 10 && n == 12) {
            n = 0;
        }
        calendar.set(n2, n);
    }

    private ClockToken[] GetTokens(String string, boolean bl) {
        ClockToken clockToken;
        ParsePosition parsePosition = new ParsePosition(0);
        Vector<ClockToken> vector = new Vector<ClockToken>(string.length());
        while ((clockToken = this.GetNextToken(string, parsePosition)) != null) {
            vector.addElement(clockToken);
        }
        Object[] objectArray = new ClockToken[vector.size()];
        vector.copyInto(objectArray);
        if (bl) {
            int n = 0;
            while (n < objectArray.length) {
                if (n != 0) {
                    System.err.print(",");
                }
                System.err.print(((ClockToken)objectArray[n]).toString());
                ++n;
            }
            System.err.println("");
        }
        return objectArray;
    }

    private ClockToken GetNextToken(String string, ParsePosition parsePosition) {
        int n;
        block7: {
            char c;
            block8: {
                int n2;
                block9: {
                    n = parsePosition.getIndex();
                    while (true) {
                        if (n < string.length() && Character.isSpaceChar(string.charAt(n))) {
                            ++n;
                            continue;
                        }
                        if (n >= string.length()) break block7;
                        c = string.charAt(n);
                        if (!Character.isDigit(c) && c != '-' && c != '+') break block8;
                        if (c != '-' && c != '+') break;
                        int n3 = n2 = c == '-' ? -1 : 1;
                        if (!Character.isDigit(string.charAt(++n))) {
                            continue;
                        }
                        break block9;
                        break;
                    }
                    n2 = 0;
                }
                int n4 = 0;
                while (n < string.length() && Character.isDigit(c = string.charAt(n))) {
                    n4 = 10 * n4 + c - 48;
                    ++n;
                }
                if (n2 < 0) {
                    n4 = -n4;
                }
                parsePosition.setIndex(n);
                return new ClockToken(n4, n2 != 0);
            }
            if (Character.isLetter(c)) {
                int n5 = n;
                while (++n < string.length()) {
                    c = string.charAt(n);
                    if (!Character.isLetter(c) && c != '.') break;
                }
                parsePosition.setIndex(n);
                return this.LookupWord(string.substring(n5, n));
            }
            parsePosition.setIndex(n + 1);
            return new ClockToken(string.charAt(n));
        }
        parsePosition.setIndex(n + 1);
        return null;
    }

    private ClockToken LookupWord(String string) {
        boolean bl;
        if (string.equalsIgnoreCase("am") || string.equalsIgnoreCase("a.m.")) {
            return new ClockToken(15, 0);
        }
        if (string.equalsIgnoreCase("pm") || string.equalsIgnoreCase("p.m.")) {
            return new ClockToken(15, 1);
        }
        if (string.length() == 3) {
            bl = true;
        } else if (string.length() == 4 && string.charAt(3) == '.') {
            bl = true;
            string = string.substring(0, 3);
        } else {
            bl = false;
        }
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(Locale.US);
        String[] stringArray = bl ? dateFormatSymbols.getShortMonths() : dateFormatSymbols.getMonths();
        int n = 0;
        while (n < stringArray.length) {
            if (string.equalsIgnoreCase(stringArray[n])) {
                return new ClockToken(5, n);
            }
            ++n;
        }
        stringArray = bl ? dateFormatSymbols.getShortWeekdays() : dateFormatSymbols.getWeekdays();
        n = 0;
        while (n < stringArray.length) {
            if (string.equalsIgnoreCase(stringArray[n])) {
                return new ClockToken(6, n);
            }
            ++n;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        n = 0;
        while (n < string.length()) {
            if (string.charAt(n) != '.') {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        String string2 = new String(stringBuffer);
        String[][] stringArray2 = dateFormatSymbols.getZoneStrings();
        n = 0;
        while (n < stringArray2.length) {
            if (string2.equalsIgnoreCase(stringArray2[n][2]) || string2.equalsIgnoreCase(stringArray2[n][4])) {
                TimeZone timeZone = TimeZone.getTimeZone(stringArray2[n][0]);
                return new ClockToken(12, timeZone);
            }
            ++n;
        }
        if (string2.equalsIgnoreCase("dst")) {
            return new ClockToken(14, null);
        }
        String string3 = string.endsWith("s") ? string.substring(0, string.length() - 1) : string;
        if (string3.equalsIgnoreCase("year")) {
            return new ClockToken(7, 12);
        }
        if (string3.equalsIgnoreCase("month")) {
            return new ClockToken(7, 1);
        }
        if (string3.equalsIgnoreCase("fortnight")) {
            return new ClockToken(8, 20160);
        }
        if (string3.equalsIgnoreCase("week")) {
            return new ClockToken(8, 10080);
        }
        if (string3.equalsIgnoreCase("day")) {
            return new ClockToken(8, 1440);
        }
        if (string3.equalsIgnoreCase("hour")) {
            return new ClockToken(8, 60);
        }
        if (string3.equalsIgnoreCase("minute")) {
            return new ClockToken(8, 1);
        }
        if (string3.equalsIgnoreCase("min")) {
            return new ClockToken(8, 1);
        }
        if (string3.equalsIgnoreCase("second")) {
            return new ClockToken(9, 1);
        }
        if (string3.equalsIgnoreCase("sec")) {
            return new ClockToken(9, 1);
        }
        if (string3.equalsIgnoreCase("tomorrow")) {
            return new ClockToken(8, 1440);
        }
        if (string3.equalsIgnoreCase("yesterday")) {
            return new ClockToken(8, -1440);
        }
        if (string3.equalsIgnoreCase("today")) {
            return new ClockToken(8, 0);
        }
        if (string3.equalsIgnoreCase("now")) {
            return new ClockToken(8, 0);
        }
        if (string3.equalsIgnoreCase("last")) {
            return new ClockToken(-1, false);
        }
        if (string3.equalsIgnoreCase("this")) {
            return new ClockToken(8, 0);
        }
        if (string3.equalsIgnoreCase("next")) {
            return new ClockToken(2, false);
        }
        if (string3.equalsIgnoreCase("ago")) {
            return new ClockToken(10, 1);
        }
        if (string3.equalsIgnoreCase("epoch")) {
            return new ClockToken(11, 0);
        }
        return new ClockToken(string);
    }

    ClockCmd() {
    }
}

