/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.IOException;
import tcl.lang.Channel;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

class GetsCmd
implements Command {
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        Channel chan;
        boolean writeToVar = false;
        String varName = "";
        if (argv.length < 2 || argv.length > 3) {
            throw new TclNumArgsException(interp, 1, argv, "channelId ?varName?");
        }
        if (argv.length == 3) {
            writeToVar = true;
            varName = argv[2].toString();
        }
        if ((chan = TclIO.getChannel(interp, argv[1].toString())) == null) {
            throw new TclException(interp, "can not find channel named \"" + argv[1].toString() + "\"");
        }
        try {
            String inStr = chan.read(interp, 2, 0);
            if (writeToVar) {
                interp.setVar(varName, TclString.newInstance((String)inStr), 0);
                if (chan.eof()) {
                    interp.setResult(-1);
                } else {
                    interp.setResult(inStr.length());
                }
            } else {
                interp.setResult(TclString.newInstance((String)inStr));
            }
        }
        catch (IOException iOException) {
            throw new TclRuntimeError("GetsCmd.cmdProc() Error: IOException when getting " + chan.getChanName());
        }
    }

    GetsCmd() {
    }
}

