/*
$Header: lex.c,v 1.1 88/01/12 16:05:06 herron Exp $
*/

/* FAS 7/19/88 - modified to read FIBRE output from sisal program */

#include <stdio.h>

int nx, ny;

char *root_name, *out_file_name, *in_file_name;
FILE *infile, *outfile;

main(argc, argv)
     int argc;
     char *argv[];
{ int i, j, r, g, b;

  if (argc > 1)
    root_name = argv[1];
  else
    root_name = "test";

  in_file_name = (char *) malloc(strlen(root_name)+5);
  out_file_name = (char *) malloc(strlen(root_name)+5);

  sprintf(in_file_name, "%s.rgb", root_name);
  sprintf(out_file_name, "%s.lex", root_name);

  infile = fopen(in_file_name, "r");
  if (!infile) {
    perror("lines (input file)");
    exit(1); }

  outfile = fopen(out_file_name, "w");
  if (!outfile) {
    perror("lines (output file)");
    exit(1); }

  fscanf (infile, "%d%d", &nx, &ny);

/* FAS - read sizes directly
  nx = getc(infile);
  nx = 256*nx + getc(infile);

  ny = getc(infile);
  ny = 256*ny + getc(infile);
*/

  fprintf(stderr, "converting %s to %s at size %dx%d.\n",
  
	  in_file_name, out_file_name, nx, ny);

  lex_begin_picture(nx, ny);

/* FAS - FIBRE output already contains color index
  for (j=0;  j<ny;  j++)
    for (i=0;  i<nx; i++) {
      r = getc(infile);
      g = getc(infile);
      b = getc(infile); 
      lex_paint_pixel(i, j, r, g, b); }
*/
  lex_end_picture();
  
}

static short bits[640*512];
static int xsize, bsize, ysize;
static int dither[256][256];
#define dithersize 8


lex_end_picture()
{ int x, y;
  int color; /* FAS */

  while (getc(infile) != ':') ;        /* FAS - skip  ':' in FIBRE */
  for (y=0;  y<ysize;  y++) {
    while (getc(infile) != ':') ;      /* FAS - skip  ':' in FIBRE */
    putw(1);			       /* rectangle limit */
    putw(640/2 - xsize/2);	       /* start x */
    putw(512/2 + ysize/2 - y - 1);     /* start y */
    putw(640/2 - xsize/2 + xsize - 1); /* stop x */
    putw(512/2 + ysize/2 - y - 1);     /* stop y */
    putw(4);			       /* sequential write */
    putw(xsize);		       /* size */
    for (x=0;  x<xsize;  x++) {
      fscanf(infile, "%d", &color);    /* FAS - read index from FIBRE */
      if ((color < 0) || (color > 999)) {
	fprintf (stderr, "color out of range\n");
	exit(1);
      }
      putw(color);
     /* putw(bits[y*xsize+x]);*/ } }

}


lex_paint_pixel(x, y, r, g, b)
     int x, y, r, g, b;
{ int ri, gi, bi, rf, gf, bf, d;

  if (r<0) r=0; else if (r>255) r=255;
  if (g<0) g=0; else if (g>255) g=255;
  if (b<0) b=0; else if (b>255) b=255;

  ri = (9*r)/256; 
  gi = (9*g)/256; 
  bi = (9*b)/256; 

  rf = 9*r - 256*ri;
  gf = 9*g - 256*gi;
  bf = 9*b - 256*bi;

  d = dither[x % dithersize][y % dithersize];
  if (rf > d) ri++;
  if (gf > d) gi++;
  if (bf > d) bi++;
  bits[y*xsize+x] = 100*ri + 10*gi + bi;

}


lex_begin_picture(xs, ys)
int xs, ys;
{ int i, j, k, size;
  int r,g,b, x,y;
  float s;

  xsize = xs;
  ysize = ys;

  putw(24);			/* configure */
  putw(640-1);  putw(512-1);  putw(16);
  putw(26);			/* set cursor */
  putw(2);  putw(0);  putw(0);
  putw(28);			/* load cursor */
  putw(1);  putw(0);
  putw(27);			/* erase cursor */
  putw(3);			/* erase screen */
  putw(0xffff);
  putw(20);			/* write lut */
  putw(1024);		/* red */
  putw(1024);		/* size */
  for (r=0;  r<255; r+=28) for (g=0;  g<255; g+=28) for (b=0;  b<255; b+=28)
    putw(r);
  for (i=0;  i<24; i++) putw(255);
  putw(20);			/* write lut */
  putw(2048);		/* green */
  putw(1024);		/* size */
  for (r=0;  r<255; r+=28) for (g=0;  g<255; g+=28) for (b=0;  b<255; b+=28)
    putw(g);
  for (i=0;  i<24; i++) putw(255);
  putw(20);			/* write lut */
  putw(3072);		/* blue */
  putw(1024);		/* size */
  for (r=0;  r<255; r+=28) for (g=0;  g<255; g+=28) for (b=0;  b<255; b+=28)
    putw(b);
  for (i=0;  i<24; i++) putw(255);

/* FAS - not needed, dithering performed by sisal
  dither[0][0] = 0;
  size = 1;
  while (size < dithersize) {
    for (j=0;  j<size;  j++)
      for (k=0;  k<size;  k++) {
	dither[j     ][k     ] = dither[j][k]*4;
	dither[j     ][k+size] = dither[j][k]+3;
	dither[j+size][k     ] = dither[j][k]+2;
	dither[j+size][k+size] = dither[j][k]+1;  }
    size = size+size;  }

  for (j=0; j<size; j++)
    for (k=0; k<size; k++)
      dither[j][k] *= 4;
*/
}


putw(w)
int w;
{
  putc(w & 255, outfile);
  putc(w >> 8, outfile);
}
