#define GRID 1.0    /* max value in domain; ie, mesh goes from 0. to grid */
                    /*  in both x and y directions  */
#define MAXPART 1000   /* max number of particles */
#define NULLPROC -99  
#define NULLCHAN -99  
#define HOST -32768

#define NCELLX 4 /* number of cells in x direction */
#define NCELLY 4  /* number of cells in y direction */
#define NPROCX 2 /* num of procs in x dir  */
#define NPROCY 1 /* num of procs in y dir  */
#define NPOINTX NCELLX+1 /* number of grid points in x dir */
#define NPOINTY NCELLY+1 /* number of grid points in y dir */
#define NPOINTS (NPOINTX+1)*(NPOINTY+1) 
#define NPOINTS_PROC NPOINTS/(NPROCX*NPROCY)
#define PART_PROC MAXPART/(NPROCX*NPROCY)+1
#define DX (GRID/NCELLX) /* mesh size  */
#define DY (GRID/NCELLY)

#define NITIT 3 /* number of time steps before completion */

#define CHG 1.0    /* unit charge of particle */
#define MASS 1.0   /*  unit particle mass  */ 

#define PI 3.14159265

#define LMAX 3
#define NX (NCELLX+2)
#define NV (NX*NX)
#define NR (4*LMAX+1+4*(NV+2*NX)/2)
#define SA 3

