signature ListPair =
sig

(* PAIRS OF LISTS

   Created by:	Dave Berry, LFCS, University of Edinburgh
		db@lfcs.ed.ac.uk
   Date:        4 Oct 1989

   Maintenance:	Author


   DESCRIPTION

   Functions on the built-in type ('a * 'b) list.


   SEE ALSO

   List, Pair.

*)

  val version: real
   (* version = 0.1 *)


(* MANIPULATORS *)

   exception Zip
   val zip: 'a list * 'b list -> ('a * 'b) list
    (* zip (l1, l2); transforms two lists into a list of pairs. It
       raises Zip if the lists are of different length. *)

   val unzip: ('a * 'b) list -> ('a list * 'b list)
    (* unzip l; transforms a list of pairs (l) into a pair of lists. *)

   val unravel: 'a list -> ('a list * 'a list)
    (* unravel l; yields a pair of lists. The elements are taken from
       l alternating one element for the first list and the following
       element for the second. *)

   val interleave: 'a list * 'a list -> 'a list
    (* interleave l1 l2; yields a list created  alternating the elements
       of l1 with the elements of l2. *)

   val merge: ('a -> 'a -> bool) -> ('a list * 'a list) -> 'a list
    (* merge p l1 l2; As interleave, merge yields a list created
       alternating the elements of l1 with the elements of l2.
       The order of insertion of a particular pair is determined
       by the predicate p. *)
end
