
loadSig "General";

structure General: General =

(* GENERAL DEFINITIONS

   Created by:  Dave Berry, LFCS, University of Edinburgh
		db@lfcs.ed.ac.uk
   Date:        21 Sep 89
*)

struct

  val version = 0.1


(* PERVASIVES *)

  exception Bind = Bind
  and Match = Match
  and Interrupt = Interrupt

  type unit = unit
  and  exn = exn

  val op o = op o
  val op <> = op <>

  exception Overflow
  and OldDiv = Div

(* TYPES *)

  datatype 'a Option = None | Some of 'a

  datatype ('a, 'b) Result = OK of 'a | Fail of 'b

  type Nat = int


  exception Nat of string * int

  exception NotImplemented of string

  exception Io of string * string * string


(* FUNCTIONS *)

  fun id x = x

  fun curry f x y = f (x, y)

  fun uncurry f (x, y) = f x y

  local
    fun iterate' 0 _ x = x
    |   iterate' n f x = iterate' (n-1) f (f x)
  in
    fun iterate n f x =
	  if n < 0 then raise Nat ("iterate", n)
	  else iterate' n f x
  end

  local
    fun repeat' 0 _ _ = ()
    |   repeat' n f x = (f x; repeat' (n-1) f x)
  in
    fun repeat n f x =
	  if n < 0 then raise Nat ("repeat", n)
	  else repeat' n f x
  end

  local
    fun primRec' _ x 0 = x
    |   primRec' f x n = primRec' f (f x n) (n-1)
  in
    fun primRec f x n =
	  if n < 0 then raise Nat ("primRec", n)
	  else primRec' f x n
  end

  fun until p f x =
    if p x then x
    else until p f (f x);
end
