(*
$File: Compiler/LAMBDA_EXP.sml $
$Date: 1992/09/17 14:17:54 $
$Revision: 1.1 $
$Locker:  $
*)

(*$LAMBDA_EXP*)
(* The lambda code is untyped, so all the constructor and record operations
   have been boiled down into tagged pairs and vectors respectively. *)

signature LAMBDA_EXP =
  sig
    type lvar
    type (''a, 'b) map

    datatype LambdaExp =
        VAR      of lvar		(* lambda variables. *)
      | INTEGER  of int			(* constants... *)
      | STRING   of string
      | REAL     of real
      | FN       of lvar * LambdaExp	(* function-terms. *)
      | FIX      of lvar list * LambdaExp list * LambdaExp
					(* mutual recursive fns. *)
      | APP      of LambdaExp * LambdaExp	(* function application. *)
      | PRIM_APP of int * LambdaExp	(* primitive function application. *)
      | VECTOR   of LambdaExp list	(* records/tuples. *)
      | SELECT   of int * LambdaExp	(* con/record indexing. *)
      | SWITCH_I of int Switch		(* switch on integers. *)
      | SWITCH_S of string Switch	(* ...strings *)
      | SWITCH_R of real Switch		(* ...reals *)
      | RAISE    of LambdaExp		(* raise exception *)
      | HANDLE   of LambdaExp * LambdaExp	(* exception handling. *)
      | REF	 of LambdaExp		(* ref(expr) *)
      | VOID				(* nil, () etc. *)

			(* HANDLE(e1, e2) executes e1; if an exception
			   packet results, e2 is applied to the packet.
			   therefore, e2 must be a FN. *)

    and 'a Switch = SWITCH of {arg: LambdaExp,
			       selections: ('a, LambdaExp) map,
			       wildcard: LambdaExp Option
				(* mandatory for REAL or STRING switches. *)
			      }

   (* Some convenient lambda-building utilities. *)
    val pair: LambdaExp * LambdaExp -> LambdaExp
    val first: LambdaExp -> LambdaExp
    val second: LambdaExp -> LambdaExp
    val Let: ((lvar * LambdaExp) * LambdaExp) -> LambdaExp

    type StringTree
    val layoutLambdaExp: LambdaExp -> StringTree
  end;
