-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: substcparms.p
-- Author: Rob Strom
-- SCCS Info: @(#)substcparms.p	1.1 7/27/89

substcparms : USING( tscheck, Predefined  ) PROCESS (SubstituteCPInit : SubstituteCallParametersInport )
-- program to substitute the actual parameters of call into a formal typestate
-- Algorithm:
-- For each object in each attribute of formal TS,
--   get the first component (if there is none, the formal TS is ill-formed)
--   Determine the ordinal position of that componentid
--   Use that ordinal position to get the actual parameter
--   Substitute the actual parameter for the formal by using the root of the
--    actual, and the components of the actual followed by the components of the formal
  DECLARE
    FP: SubstituteCallParametersCall ;
  BEGIN
    RECEIVE FP FROM SubstituteCPInit ;
    NEW FP.ActualTypestate;
    FOR FormalAttribute IN FP.FormalTypestate WHERE(FORALL OF FO IN FormalAttribute.Parameters WHERE(SIZE OF FO > 0))
      INSPECT
        INSERT (EVALUATE Attribute: Attribute FROM
          NEW Attribute;
          Attribute.Name := FormalAttribute.Attribute_Name;
          NEW Attribute.Objects;
	  FOR FormalObject IN FormalAttribute.Parameters WHERE(boolean # 'true')
            INSPECT
              INSERT (EVALUATE Object: ObjectName FROM
                NEW Object;
                INSPECT FormalComponent IN FormalObject WHERE(boolean # (integer # (POSITION OF FormalComponent) = integer # (0)))
                  BEGIN
		    INSPECT ActualParameter IN FP.Operands[POSITION OF CPComponent IN FP.CallmessageComponents WHERE(CPComponent.Id = FormalComponent) + 1]
		      BEGIN
			Object.Root := ActualParameter.Root;
--                          Object.Components <- component_list # (ActualParameter.Components | component_list # (EVERY OF Component IN FormalObject WHERE(boolean # (integer # (POSITION OF Component) > integer # (0)))));
-- EVERY OF not supported
			   Object.Components := ActualParameter.Components;
			FOR Component IN FormalObject WHERE(boolean # (integer # (POSITION OF Component) > integer # (0)))
			  INSPECT
			    INSERT ComponentId # (COPY OF Component) INTO Object.Components;
			  END FOR;
		      END INSPECT;
                  END INSPECT;
                END) INTO Attribute.Objects;	
	    END FOR;
          END) INTO FP.ActualTypestate;
      END FOR;
    RETURN FP;
  END PROCESS
