-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS info: @(#)type.d	1.6 1/25/92
type: using(Predefined, inferredtype, checking_table, errors, stdenv,
  type_inference, positions)
definitions

  -- following tables are ordered only so error messages will come out
  -- in a semi-reasonable order without having to sort them.
  -- Eventually they should be sorted, and these tables no longer need
  -- be ordered.
  SetOfClauseId: ordered table of clauseid {full} keys (*);
  SetOfAPosition: ordered table of APosition {full};

  backPatchTable: table of backPatchRecord {full};
  ruleType: enumeration ('assignment', 'inference','class','call');
  backpatchRecord: record (
    triggerObj: rootname,	-- root object whose type must be
				-- known for this entry to be fired
    info: backpatchInfo
  );
  backpatchInfo: variant of ruleType (
    'assignment' -> assign: backpatchAssign {full},
    'inference' -> infer: backpatchInfer {full},
    'class' -> class: backpatchClass {full},
    'call' -> call: aposition {full}
  );
  backpatchAssign: record (
    function: type_assignment_function,
    resultObj: objectname,
    position: aposition
  );
  backpatchInfer: record (
    function: type_inference_function,
    resultObj: objectname,
    argumentObj: objectname,
    position: aposition
  );
  backpatchClass: record (
    function: type_class_function,
    resultObj: objectname,
    position: aposition
  );

  -- the findTypeMessage is the type of message passed to the "find type of 
  -- objectname' process.
  findTypeMessage: callmessage (
    object: objectname,		-- to find the type of this object 
    scopes: scopes,		-- contains declarations of program,
				-- including the declaration of the
				-- object
    definitions: definitions_modules,-- definitions that are used by
				     -- object or its components
    inferred: InferredDefinitions,-- types that have been inferred
				  -- already 
    object_type: typename	-- the type of object (the result of
				-- the function call) 
  )
  constant(object, scopes, definitions, inferred)
  exit {full}
  exception unknown_type  {full(object), full(scopes),  full(definitions), 
    full(inferred)};
  findTypeQueue: inport of findTypeMessage {full(object), full(scopes),  
    full(definitions), full(inferred)};
  findTypeCapa: outport of findTypeQueue;

  -- interface for process that locates the type definition
  -- corresponding to a given typename
  finddefMessage: callmessage(
    arg_type: typename,
    definitions: definitions_modules,
    definition: type_definition
  ) 
  constant(arg_type, definitions)
  exit{full};

  finddefQueue: inport of finddefMessage {full(arg_type), full(definitions)};
  finddefCapa: outport of finddefQueue;

  -- the qualCheckMessage is the type of message passed to the
  -- statement qualifier checking process
  qualCheckMessage: callmessage (
    stmt: statement,		-- stmt whose qualifier is to be checked
    scopes: scopes,		-- where to find declartions
    workList: setOfClauseId,	-- clauses still to be processed
    inferred: inferredDefinitions,-- types that have been inferred already
    newlyInferred: rootnames,	-- types inferred while checking this stmt
    backpatch: backpatchTable,	-- rules that can't be checked yet
    literalStmts: setOfAPosition,-- statements with literals to be checked
    assignPort: assignCapa,	-- capabilities to rule checkers
    inferPort: inferCapa,
    classPort: classCapa,
    errors: errors,
    position: aposition		-- this stmt position, for error messages
  )
  constant (stmt, scopes, assignPort, inferPort, classPort, position)
  exit {full}
  minimum {full};
  qualCheckQueue: inport of qualCheckMessage {full};
  qualCheckCapa: outport of qualCheckQueue;
 
  -- the stmtCheckMessage is the type of message passed to stmt
  -- checking process 
  stmtCheckMessage: callmessage (
    stmt: statement,		-- stmt to be checked 
    clause_id: clauseid,	-- clauseid of clause in which stmt belongs
    scopes: scopes,		-- contains declarations of operands of stmt 
    definitions: definitions_modules, -- definitions that are used in prog
    inferred: InferredDefinitions,-- types that have been inferred already
    backpatch: backPatchTable,
    checking_record: checking_record,-- inference and class rules for
				     -- this statement 
    errors:errors,
    findTypePort: findTypeCapa,
    findDefPort: findDefCapa,
    AssignPort: AssignCapa,
    InferPort: InferCapa,
    ClassPort: ClassCapa,    
    InterfaceCheckPort: InterfaceCheckCapa,
    componentsOverlap: componentsOverlapCapa,
    newlyInferred: rootnames	-- objects inferred by this call
  )
  constant(stmt, clause_id, scopes, definitions, checking_record,
      findTypePort, AssignPort, InferPort, ClassPort, InterfaceCheckPort,
      componentsOverlap)
  exit {full}
  minimum {full};
  stmtCheckQueue: inport of stmtCheckMessage {full};
  stmtCheckCapa: outport of stmtCheckQueue;

  -- the RecheckInfMessage is the type of message passed to rechecking
  -- inference rule process
  RecheckInferMessage: callmessage (
    bpInfer: backpatchInfer,	-- the backpatch record information
    inferred: InferredDefinitions,-- types that have been inferred already
    newlyInferred: rootnames,	-- variables inferred during this call
    backpatch: backpatchTable,	-- an inference need to be re-backpatched
    errors:errors,
    InferPort: InferCapa	-- an outport to the function that calls
				-- the appropriate type inference function
  ) 
  constant(bpInfer, InferPort)
  exit {full}
  minimum {full};
  RecheckInferQueue: inport of RecheckInferMessage {full};
  RecheckInferCapa: outport of RecheckInferQueue;

  -- the RecheckClassMessage is the type of message passed to
  -- rechecking class rule process 
  RecheckClassMessage: callmessage (
    bpClass: backpatchClass,	-- the backpatch info
    inferred: InferredDefinitions,-- types that have been inferred already
    errors: errors,
    ClassPort: ClassCapa	-- an outport to the function that calls the 
				-- appropriate type class rule
  )
  constant(bpClass, inferred, ClassPort)
  exit {full}
  minimum {full};
  RecheckClassQueue: inport of RecheckClassMessage {full};
  RecheckClassCapa: outport of RecheckClassQueue;
    
  -- literalCheckMessage is the message sent to the process that
  -- checks the qualifiers for string_literal and named_literal
  -- statements
  literalCheckMessage: callmessage (
    stmt: statement,		-- statement to be checked
    clause_id: clauseid,	-- id of clause containing stmt
    scopes: scopes,		-- user declarations of operands
    definitions: definitions_modules,-- definitions used in stmt
    inferred: inferredDefinitions,-- declarations that have been inferred
    errors: errors,
    findType: findTypeCapa,
    findDef: findDefCapa
  )
  constant (stmt, clause_id, scopes, definitions, inferred, findType, findDef)
  exit {full}
  minimum {full};
  literalCheckQueue: inport of literalCheckMessage {full};
  literalCheckCapa: outport of literalCheckQueue;
  
  -- the assignment rule checker, which invokes an assignment rule and
  -- updates the inference list, and error list as necessary
  AssignMessage: callmessage (
    function: type_assignment_function,
    object: objectname,		-- variable being checked/inferred
    inferred: inferredDefinitions,-- list of inferences made so far
    newlyInferred: rootnames,	-- vars inferred for this stmt
    backpatch: backpatchTable,	-- rules that can't be checked yet
    errors: errors,
    position: aposition		-- current position, for error messages
  )
  constant(function, object, position)
  exit {full}
  minimum {full};

  AssignQueue: INPORT OF AssignMessage {full};
  AssignCapa: OUTPORT OF AssignQueue;

  -- AssignRuleMessage is sent to a process implementing a particular
  -- assignment rule
  AssignRuleMessage: callmessage (
    result: typename
  )
  exit {full};
  AssignRuleQueue: inport of AssignRuleMessage {};
  AssignRuleCapa: outport of AssignRuleQueue;
  
  -- initport for a process that will dispatch assignment rule
  -- checking calls and update inference and error tables
  -- appropriately
  SetupAssignMessage: callmessage (
    findType: findTypeCapa,
    program: proc,
    definitions: definitions_modules,
    assign_func: AssignCapa
  )
  constant( findType, program, definitions)
  exit {full};
  SetupAssignQueue: INPORT OF SetupAssignMessage 
      {full(findType), full(program), full(definitions)};
  SetupAssignCapa: OUTPORT OF SetupAssignQueue;

  -- the inference rule checker, which invokes an inference rule and
  -- updates the inference list, error list, and backpatch table as
  -- necessary
  InferMessage: callmessage (
    function: type_inference_function,
    object: objectname,		-- variable being checked/inferred
    argument: objectname,	-- argument from which inference is
				-- being made
    inferred: inferredDefinitions,-- inferences made so far
    newlyInferred: rootnames,	-- vars inferered for this stmt
    backpatch: backpatchTable,	-- rules that need to be rechecked later
    errors: errors,
    position: aposition		-- current position, for error messages
  )
  constant(function, object, argument, position)
  exit {full}
  minimum {full};
  InferQueue: INPORT OF InferMessage {full};
  InferCapa: OUTPORT OF InferQueue;
    
  -- InferRuleMessage is sent to a process implementing a particular
  -- inference rule
  InferRuleMessage: callmessage (
    argument: typename,
    definitions: definitions_modules,
    result: typename
  )
  constant (argument, definitions)
  exit {full}
  exception wrongArgType {full(argument), full(definitions)};
  InferRuleQueue: inport of InferRuleMessage 
      {full(argument), full(definitions)};
  InferRuleCapa: outport of InferRuleQueue;

  -- initport for a process that will dispatch inference rule checking
  -- calls and update inference, error and backpatch tables
  -- appropriately
  
  SetupInferMessage: callmessage (
    findType: findTypeCapa,
    program: proc,
    definitions: definitions_modules,
    infer_func: InferCapa
  )   
  constant(findType, program, definitions)
  exit {full};

  SetupInferQueue: INPORT OF SetupInferMessage {
    full(findType), full(program), full(definitions)};
  SetupInferCapa: OUTPORT OF SetupInferQueue;

  -- the class rule checker, which invokes a class rule and updates
  -- the error list and backpatch table as necessary
  ClassMessage: callmessage (
    function: type_class_function,
    object: objectname,		-- the object being checked
    inferred: inferredDefinitions,-- inferences made so far
    backpatch: backpatchTable,	-- rules that need to be rechecked later
    errors: errors,
    position: aposition		-- current position, for error messages
  )
  constant(function, object, inferred, position)
  exit {full}
  minimum {full};
  ClassQueue: INPORT OF ClassMessage {full};
  ClassCapa: OUTPORT OF ClassQueue;

  -- ClassRuleMessage is sent to a process implementing a particular
  -- class rule
  ClassRuleMessage: callmessage (
    argument: typename,
    definitions: definitions_modules,
    result: boolean
  )
  constant(argument, definitions)
  exit {full};
  ClassRuleQueue: inport of ClassRuleMessage 
      {full(argument), full(definitions)};
  ClassRuleCapa: outport of ClassRuleQueue;

  -- initport for a process that will dispatch class rule checking
  -- calls and update error and backpatch tables
  SetupClassMessage: callmessage (
    findType: findTypeCapa,
    program: proc,
    definitions: definitions_modules,
    Class_func: ClassCapa
  )
  constant(findType, program, definitions)
  exit {full};
  SetupClassQueue: INPORT OF SetupClassMessage 
      {full(findType), full(program), full(definitions)};
  SetupClassCapa: OUTPORT OF SetupClassQueue;


  -- the following interrface is used by the function 'Copyable',
  -- rather than the standard ClassRule interface, because of the
  -- extra 'encounteredTypes' arg that must be maintained through
  -- recursive calls
  CopyableMessage: callmessage (
    argument: typename,
    definitions: definitions_modules,
    encounteredTypes: SetOfTypename,
    result: boolean
  )
  constant(argument, definitions)
  exit {full};
  CopyableQueue: INPORT OF CopyableMessage 
      {full(argument), full(definitions), full(encounteredTypes)};
  CopyableCapa: OUTPORT OF CopyableQueue;

  SetOfTypename: table of typename {full} keys(*);

  -- another class function that requires a nonstandard interface
  VariantComponentMessage: callmessage (
    argument: objectname,
    scopes: scopes,		-- find declaration for argument's root here
    definitions: definitions_modules,
    variantPort: classRuleCapa,	-- capability to variant class checker
    result: boolean
  )
  constant(argument, scopes, definitions, variantPort)
  exit {full};
  VariantComponentQueue: inport of VariantComponentMessage
      {full(argument), full(scopes), full(definitions), full(variantPort)};
  VariantComponentCapa: outport of VariantComponentQueue;

  -- interface for function to check if two tables of components overlap
  componentsOverlapIntf: callmessage(
    comp1: component_list,
    comp2: component_list,
    result: boolean
  )
  constant(comp1, comp2)
  exit {full};
  componentsOverlapQueue: inport of componentsOverlapIntf 
       {full(comp1), full(comp2)};
  componentsOverlapCapa: outport of componentsOverlapQueue;

  -- interface for function to check call statements for compliance
  -- with the declared interface of the called port
  interfaceCheckMessage: callmessage(
    stmt: statement,		-- 'call' statement to be checked
    clause_id: clauseid,	-- id of clause containing stmt
    scopes: scopes,		-- declarations of statement operands
    definitions: definitions_modules,-- definitions for types used in stmt
    inferred: InferredDefinitions,-- types previously inferred
    backpatch: backPatchTable,	-- table of things to be rechecked later
    errors:errors,
    findTypePort: findTypeCapa,
    finddefPort: finddefCapa,
    componentsOverlap: componentsOverlapCapa,
    newlyInferred: rootnames	-- variables inferred during this call
  )
  constant(stmt, clause_id, scopes, definitions, findTypePort, finddefPort, 
           componentsOverlap)
  exit {full}
  minimum {full};
  interfaceCheckQueue: inport of interfaceCheckMessage {full};
  interfaceCheckCapa: outport of interfaceCheckQueue;

end definitions
