-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: recheckclass.p
-- Author: Dan Yellin
-- SCCS Info: @(#)recheckclass.p	1.3 3/13/90

-- This process rechecks a class rule that was postponed because the
-- argument object's type was not yet known.  That type is known now,
-- so we can perform the check.  Errors may be generated.

recheckclass: using(predefined, type, type_inference, errors, positions)
process(RecheckPort:RecheckClassQueue)
DECLARE
  RecheckCall: RecheckClassMessage;
  backpatch: backpatchTable;
BEGIN
  RECEIVE RecheckCall FROM RecheckPort;

  -- allocate a local backpatch table for the call... it should not
  -- get used 
  new backpatch;
  -- Now invoke the class checker
  call RecheckCall.ClassPort(RecheckCall.bpClass.function,
    RecheckCall.bpClass.resultObj, RecheckCall.inferred, backpatch,
    RecheckCall.errors, RecheckCall.bpClass.position);

  if size of backpatch <> 0 then
    exit cantHappen;
  end if;
  
  RETURN RecheckCall;
  
on exit(cantHappen)
  print charstring#"RecheckClass created a backpatch entry?";
END process
