-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS info: @(#)orderedtable.p	1.3 3/13/90 
-- checks that the argument is an ordered table
orderedtable: using(type)
PROCESS(ClassQ: ClassRuleQueue)
DECLARE
    ClassM: ClassRuleMessage;

BEGIN
  RECEIVE ClassM FROM ClassQ;
  INSPECT definitions_module IN ClassM.definitions 
    	WHERE(definitions_module.id = ClassM.argument.moduleid)
  BEGIN
    INSPECT type_def IN definitions_module.type_definitions
	  WHERE(type_def.id = ClassM.argument.typeid)
    BEGIN
      BLOCK
      BEGIN
	REVEAL type_def.specification.table_info;
	IF type_def.specification.table_info.ordered_table
	THEN 
	  ClassM.result <- 'true';   -- it is an ordered table
	ELSE
	  ClassM.result <- 'false'; 
	END IF;
      ON (CaseError) 
	ClassM.result <- 'false'; -- the argument is not a table type 
      END BLOCK;
    END INSPECT;
  END INSPECT;
  RETURN ClassM;
END process
