/* (C) Copyright International Business Machines Corporation 23 January  */
/* 1990.  All Rights Reserved.  */
/*   */
/* See the file USERAGREEMENT distributed with this software for full  */
/* terms and conditions of use.  */
/* File: Makefile */
/* Author: David F. Bacon */
/* SCCS info: @(#)Makefile	1.17 2/7/92  */

/* Makefile is the makefile for this directory (hermes/type/checker) which makes */
/* the typechecker for the Hermes compiler.  It uses the bootstrap version of */
/* the compiler in hermes/type/bootstrap and hermes/type/common. */

TCDEFDIR =	$(HROOT)/type/defs
TCCOMDIR =	$(HROOT)/type/common
TCBOOTDIR =	$(HROOT)/type/bootstrap

/* #ifdef'd modules from $(TCCOMDIR) */
BSSRC	=	$(TCCOMDIR)/interfacecheck.bs $(TCCOMDIR)/stmtchecker.bs \
		$(TCCOMDIR)/recheckinfer.bs $(TCCOMDIR)/type.bs \
		$(TCCOMDIR)/qualchecker.bs
BSINT	=	interfacecheck.p stmtchecker.p recheckinfer.p type.p \
		qualchecker.p
BSOBJ	=	interfacecheck.po stmtchecker.po recheckinfer.po type.po \
		qualchecker.po
BSOBJZ	=	interfacecheck.po.Z stmtchecker.po.Z recheckinfer.po.Z type.po.Z \
		qualchecker.po.Z

/* main modules not used in bootstrap version */
MAINSRC	=	recheckclass.p  literalcheck.p class.p
MAINOBJ	=	recheckclass.po literalcheck.po class.po
MAINOBJZ=	recheckclass.po.Z literalcheck.po.Z class.po.Z

/* class rule modules */
CLASSSRC=	boolean.p numeric.p variant.p string.p inport.p \
		outport.p orderedscalar.p table.p integer.p \
		enumerationorboolean.p nominal.p enumeration.p newable.p \
		polymorph.p copyable.p orderedtable.p callmess.p \
		variantcomponent.p real.p
CLASSOBJ=	boolean.po numeric.po variant.po string.po inport.po \
		outport.po orderedscalar.po table.po integer.po \
		enumerationorboolean.po nominal.po enumeration.po newable.po \
		polymorph.po copyable.po orderedtable.po callmess.po \
		variantcomponent.po real.po
CLASSOBJZ=	boolean.po.Z numeric.po.Z variant.po.Z string.po.Z inport.po.Z \
		outport.po.Z orderedscalar.po.Z table.po.Z integer.po.Z \
		enumerationorboolean.po.Z nominal.po.Z enumeration.po.Z newable.po.Z \
		polymorph.po.Z copyable.po.Z orderedtable.po.Z callmess.po.Z \
		variantcomponent.po.Z real.po.Z

/* combined modules */
SRC	=	$(BSSRC) $(MAINSRC) $(CLASSSRC)
INT	=	$(BSINT)
PROCOBJS =	$(BSOBJ) $(MAINOBJ) $(CLASSOBJ)
PROCOBJSZ = $(BSOBJZ) $(MAINOBJZ) $(CLASSOBJZ)

#include "includefile"


EXTRACPPFLAGS =	-DFullChecking -Udebug

/* Include typechecker local defs in DEFPATH, and the bootstrapping */
/* typechecker and common directories in LOADPATH.  Note that if you want */
/* to use the bootstrapper, you must not have any of the bootstrapped */
/* or common modules in $(PROCDIR).  The path ordering is as given so */
/* the more common situation of recompiling the typechecker with */
/* changes that do not require bumping to a new version. */
DEFPATH	=	$(TCDEFDIR):$(DEFDIR)
LOADPATH= 	$(PROCDIR):$(TCCOMDIR):$(TCBOOTDIR)
LINKPATH =	.:$(TCCOMDIR):$(TCBOOTDIR)

all:	$(SRC) $(INT) compileprocs

install: all
	cp type.po $(PROCDIR)

chcode:
	$(CHCODECMD) type -load=.
chcompile:
	$(CHCOMPILECMD) type -load=.


/* Main type checking modules */
/* note: dependencies upon non-local definitions have been omitted */

/* *.bs files from $(TCCOMDIR) */

#include "../common/bsmake"

/* additional dependencies due to links */
type.po: class.po recheckclass.po literalcheck.po
class.po: $(CLASSOBJ)
