-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)unixcmd.p	1.5 1/27/92

unixCmd: using (predefined, unixCmd, unix, terminalIO)
process (q: unixCmdQ)

declare
  m: unixCmd;
  inpipe: stream;

begin
  receive m from q;

  block begin
    inpipe <- m.popen(m.cmd, 'read');

    block begin
      while 'true' repeat
	call m.putString(inpipe.fgets(80));
      end while;
    on (getBoundedStringIntf.endOfInput)
      call inpipe.pclose();
      return m;
    end block;
  on (others)
    return m exception cantExec;
  end block;

end process
