-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)sh.p	1.6 1/11/92

sh: using (predefined, main, unixcmd, load, unix)
process (initQ: mainQ)

declare
  init: main;
  unixcmd: unixCmdFunc;
  cmd: charstring;
  status: integer;
  pathLoad: load_func;
  stdio: stdio;

begin
  receive init from initQ;
  unwrap pathLoad from init.rm.get("pathLoad", "") {init};
  unwrap stdio from init.rm.get("stdio", "") { init, init(popen)};
  new cmd;

  for arg in init.argv where (boolean#'true') inspect
    if boolean#(integer#(position of arg) >= integer#3) then
      insert char#' ' into cmd;
    end if;

    if boolean#(integer#(position of arg) >= integer#2) then
      merge charstring#(copy of arg) into cmd;
    end if;
  end for;

  unixcmd <- unixCmdFunc#(create of program#(pathload(charstring#"unixcmd")));
  call unixcmd(cmd, stdio.popen, init.terminal.putString, status);

  return init;

on (unixCmd.cantExec)
  call init.terminal.putString(charstring#"sh: couldn't exec """);
  call init.terminal.putString(cmd);
  call init.terminal.putLine(charstring#""".");
  return init;

on (unixCmd.programException)
  call init.terminal.putLine(charstring#"sh: non-zero return code.");
  return init;

end process
