-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: pshell.d
-- Author: Andy Lowry
-- SCCS Info: @(#)pshell.d	1.4 3/11/91

-- Internal definitions need by the pshell

pshell: using (common, tokenize, plumbing, rmanager, terminalIO)

definitions
  
  -- Interface for command line parser.  See pshell.p for details on
  -- the syntax.
  parseProcNet: callmessage (
    rm: rManager,
    terminal: terminalFunctions,-- base terminal I/O functions
    cmd: tokenList,		-- tokenized command line
    procs: procSet,		-- processes comprising network
    pipes: pipeSet,		-- pipes connecting network processes
    asynchronous: boolean,	-- false means plumber should wait for all
				-- network processes to return before
				-- returning
    failer: charString
  )
  constant (rm, terminal, cmd)
  exit {full(rm), full(terminal), init(cmd), init(procs), init(pipes),
    init(asynchronous)}
  exception procFailure 
      {full(rm), full(terminal), init(cmd), init(failer)}
  exception pipeFailure
      {full(rm), full(terminal), init(cmd), init(failer)}
  exception syntaxError {full(rm), full(terminal), init(cmd)};
  
  parseProcNetQ: inport of parseProcNet 
      {full(rm), full(terminal), init(cmd)};
  parseProcNetFn: outport of parseProcNetQ;
  
  -- interface for process to parse a single process specification
  parseProc: callmessage (
    toks: tokenList,
    procs: procInfoSet,
    labels: procLabels,
    proc: procID
  )
  exit {full}
  exception syntaxError {init(toks), init(procs), init(labels)};
  
  parseProcQ: inport of parseProc {init(toks), init(procs), init(labels)};
  parseProcFn: outport of parseProcQ;
  
  -- interface to process which will parse a pipe specification
  parsePipe: callmessage (
    toks: tokenList,
    pipe: pipeInfo
  )
  exit {full}
  exception syntaxError {init(toks)};
  
  parsePipeQ: inport of parsePipe {init(toks)};
  parsePipeFn: outport of parsePipeQ;
  
  -- table relating process labels to their procID's
  procLabels: table of procLabel {full} keys (label);
  procLabel: record (
    label: charstring,
    proc: procID,
    defined: boolean
  );

  -- States in the top-level parser state machine
  topState: enumeration ('proc', 'pipe', 'done');

  -- States in process parser state machine
  procState: enumeration ('start', 'getColon', 'gotLabel', 'args', 'done');

  -- States in pipe parser state machine
  pipeState: enumeration ('start', 'name1', 'comma', 'name2', 'rBracket',
    'done');

  -- Info about a parsed process specification, not yet resolved into
  -- the procSet representation
  procInfoSet: table of procInfo {full} keys (id);
  procInfo: record (
    id: procID,
    name: charString,
    args: charStringList
  );

  -- Info about a parsed pipe, not yet resolved into the pipeSet
  -- representation
  pipeInfoSet: table of pipeInfo {full};
  pipeInfo: record (
    id: pipeID,
    source: procID,
    sourceName: charString,
    dest: procID,
    destName: charString
  );

  -- Saved parser info in top-level parser, saved across <..> constructs
  parseStack: ordered table of parseInfo {full};
  parseInfo: record (
    pushedFrom: topState,
    source: procID,
    pipes: pipeInfoSet
  );

end definitions
