-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: string2stdout.p
-- Author: Andy Lowry
-- SCCS Info: @(#)string2stdout.p	1.3 3/11/91

-- This process receives strings on a string port and sends them via
-- putLine to its stdout

string2stdout: using (main, stdio, stringpipe)

process (Q: mainQ)
  
declare
  args: main;
  stdin: stringQ;
  stdout: stdout;
  s: charString;
begin
  receive args from Q;
  
  -- get our pipe ports
  unwrap stdin from args.rm.get("stdin", "string") {init};
  unwrap stdout from args.rm.get("stdout", "stdio") {init, init(putLine)};
  
  while 'true' repeat
    receive s from stdin;
    call stdout.putLine(s);
  end while;
  
end process
