-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: getNonCommentLine.p
-- Author: Daniel Yellin
-- SCCS Info: "@(#)getnoncommentline.p	1.5 1/20/92"
-- getNonCommentLine(getstring:getStringFunc) returns the next 
-- non-comment line in the Hermes program. The returned line is
-- stripped of leading and trailing spaces and of any comments.  

getNonCommentLine: using(predefined,terminalio,getuses)
process(getQ: getlineQ)

declare
  getM: getlineIntf;
  line: charstring;
  ncline: charstring;
  c: char;
  state: char;
  empty: boolean;
begin
  block begin
    receive getM from getQ;
    line <- "";
    ncline <- "";
    empty <- 'true';

    while size of ncline = 0 repeat
      -- get some text to work on
      while size of line = 0 repeat
	line <- getM.getstring();
      end while;
      
      block begin
	state <- 'S';		-- begin in scan state
	while size of line > 0 repeat
	  block begin
	    empty <- size of ncline = 0;
	    remove c from line[];
	    select state
	    where ('S')		-- normal scan state
	      select c
	      where (' ')	-- skip whitespace at beginning of line
		if not empty then
		  insert c into ncline;
		end if;
	      where ('HT')
		if not empty then
		  insert c into ncline;
		end if;
	      where ('"')	-- begin quoted string
		insert c into ncline;
		state <- '"';
	      where ('''')		-- begin literal name
		insert c into ncline;
		state <- '''';
	      where ('-')	-- might be comment to end of line
		if (size of line > 0) then
		  if line[0] = '-' then
		    exit doneLine;-- if so there's nothing more on this line
		  end if;
		end if;
		insert c into ncline;-- else it's just a normal hyphen
	      where ('/')	-- might begin an embedded comment
		if (size of line > 0) then
		  if (line[0] = '*') then
		    remove c from line[0];-- yes
		    state <- 'C';
		    exit continue;
		  end if;
		end if;
		insert c into ncline;-- else it's just a slash
	      otherwise		-- any other char
		insert c into ncline;
	      end select;
	      
	    where ('"')
	      insert copy of c into ncline;
	      if c = '"' then
		if size of line > 0 then
		  if line[0] = '"' then
		    remove c from line[];-- doubled quote - still in string
		    insert c into ncline;
		    exit continue;
		  end if;
		end if;
		state <- 'S';	-- this was the terminating quote
	      end if;
	      
	    where ('''')
	      insert copy of c into ncline;
	      if c = '''' then
		if size of line > 0 then
		  if line[0] = '''' then
		    remove c from line[];-- doubled quote - still in name
		    insert c into ncline;
		    exit continue;
		  end if;
		end if;
		state <- 'S';-- this was the terminating quote
	      end if;
		
	    where ('C')
	      if c = '*' then
		if size of line > 0 then
		  if line[0] = '/' then
		    remove c from line[];-- end of comment
		    if not empty then
		      insert ' ' into ncline;-- treat like a space
		    end if;
		    state <- 'S';
		    exit continue;
		  end if;
		end if;
	      end if;
	      -- still in comment
	    otherwise
	      exit cantHappen;
	    end select;
	  on exit(continue)
	  end block;
	end while;
      on exit(doneLine)
	line <- "";
      end block;
    end while;
      
    getM.s <- ncline;
    return getM;

  on (getStringIntf.endOfInput)
    return getM exception endOfInput;
  end block;
on exit(cantHappen)
end process



