-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: getuses.d
-- Author: Daniel Yellin
-- SCCS Info: "@(#)getuses.d	1.4 1/20/92"
-- description:  interfaces used by getuses
getuses: using(make,common,unix,findfile,terminalio,load)
definitions

-- Interface for a fucntion that scans the named Hermes source file for
-- using() and linking() lists, and returns a list of id's of nodes on
-- corresponding to the indicated object modules 
getusesIntf: callmessage (
   name: charstring,
   uses: nodeIDs
) constant (name)
  exit {full}
  exception getusesfailure {init(name)};
getusesQ: inport of getusesIntf {init(name)};
getusesFn: outport of getusesQ;

-- setupGetusesIntf is passed some capabilities and returns a getuses
-- function
setupGetusesIntf: callmessage (
   pathload: load!load_func,
   fopen: fopenFn,
   getuses: getusesFn
) constant(pathload, fopen)
  exit {full};
setupGetusesQ: inport of setupGetusesIntf {init(pathload), init(fopen)};
setupGetusesService: outport of setupGetusesQ;

-- getlineIntf is an interface to a group of functions that take
-- a getstring function and return a string.  For example, a particular
-- function using this interface may get the next "line" from the file,
-- filter out leading spaces, and return the resultant string.  
getlineIntf: callmessage (
   getstring: terminalio!getStringFunc,
   s: charstring
) constant(getstring)
  exit{full}
  minimum {full(getstring)}
  exception endOfInput {full(getstring)};  
getlineQ: inport of getlineIntf {full(getstring)};
getlineFunc: outport of getlineQ;

end definitions
