-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: netlink.p
-- Author: Andy Lowry
-- SCCS Info: @(#)getlink.p	1.1 3/11/91

-- This process takes arguments of the form "host:n" where host is the
-- name of a network host and n is the interpreter number of a Hermes
-- interpreter running on that host.  (If n is omitted it defaults to
-- 1.)  We issue a "get link" request for each arg, make a call on the
-- resulting port and unwrap the returned value as a resource manager.
-- We chain all the returned RM's together, with our own on top, and
-- replace the RM we were called with by the chained RM.

getlink: using (sysMain, CLoad, distributed, string, common,
  sysRManager, chainedRM)
linking (atoi, chainedSysRM)

process (Q: sysMainQ)
  
declare
  args: sysMain;
  RMList: sysRMList;
  rm: sysRManager;
  CLoad: CLoadFn;
  getLink: getLinkFn;
  atoi: string2IntFn;
begin
  receive args from Q;
  
  unwrap CLoad from args.rm.get("system", "CLoader", "") {init};
  unwrap getLink from CLoad("get link") {init};
  atoi <- procedure of process atoi;

  -- start out our list of RM's with the one we were called with
  new RMList;
  insert copy of args.rm into RMList;
  
  -- now retrieve an RM from each interpreter listed in the args
  for arg in args.argv where (position of arg >= 2) inspect
    block declare
      host: charString;
      interpNo: integer;
      colonPos: integer;
      linkFn: genericFn;
      empty: empty;
      linkObj: polymorph;
    begin
      block begin
	colonPos <- position of c in arg where (c = ':');
	host <- every of c in arg where (position of c < colonPos);
	interpNo <- atoi(every of c in arg where (position of c > colonPos));
      on (notFound)
	host := arg;
	interpNo <- 1;
      end block;
      linkFn <- getLink(host, interpNo);
      wrap empty as LinkObj;
      call linkFn(linkObj);
      unwrap rm from linkObj {
	init, init(post), init(insert), init(get), init(remove), init(delete)};
      insert rm into RMList;
    end block;
  end for;
  
  -- create a chained RM from the RM list we've obtained and replace
  -- the RM from our callmessage
  args.rm <- chainedSysRMInitFn#(create of process chainedSysRM)
      (RMList, args.rm);
  return args;
  
end process
  
