-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: 
   
defmodCache: using(predefined, defmodCache, common)
process (init: initdmcacheQ)
    
declare
  initargs: initdmcache;
  
  sharedmQ: sharedefmodQ;
  
  dmtab: definitions_modules;
begin
  receive initargs from init;
  new sharedmQ;
  connect initargs.sharedefmod to sharedmQ;
  return initargs;
  
  new dmtab;
  
  while boolean#'true' repeat
      block
        declare
          arg: shareDefmodCm;
          defmod: definitions_module;
          newDefinitions: definitions_modules;
        begin
          receive arg from sharedmQ;
          
          new newDefinitions;
          while boolean#(integer#(size of arg.prog.definitions_modules) 
                     <> integer#(0)) repeat
              -- remove defmod from arg.prog.definitions_modules[];
              remove defmod from x in arg.prog.definitions_modules 
                 where (boolean#'true');
              
              block
                begin
                  inspect cachedDefmod in dmtab where
                         (boolean#(defmod.id = cachedDefmod.id))
                    begin
                      -- yes, this looks like it does nothing, but with lazy
                      -- copying this should discard the extra copy of defmod;
                      discard defmod;
                      pragma "make a lazy copy, bub" insert definitions_module#(copy of cachedDefmod) into newDefinitions;
                    end inspect;
                on (NotFound)
                  -- save a copy in the cache
                  insert definitions_module#(copy of defmod) into dmtab;
                  -- put back defmod
                  insert defmod into newDefinitions;
                end block;
            end while;
          
          arg.prog.definitions_modules <- newDefinitions;

	  -- restore checked attribute on the program
          block declare
	    poly: polymorph;
	  begin
	    wrap arg.prog as poly;
	    unwrap arg.prog from poly  {
	      init, checked, init(definitions_modules), 
	      init(main_program), init(programs)
	    };
	  end block;
          return arg;
        end block;
    end while;

end process

