# (C) Copyright International Business Machines Corporation 23 January 
# 1990.  All Rights Reserved. 
#  
# See the file USERAGREEMENT distributed with this software for full 
# terms and conditions of use. 
# SCCS Info: @(#)opcodes.awk	1.3 3/14/90

BEGIN {
	FS = "|"
	opcode = 0
	print "#include \"opfuncdefs.h\"" > "func2op.c"
	print "void (*func2op_map[])() = {" > "func2op.c"
	print "char *op_names[] = {" > "opnames.c"
}


/^[a-z]/ {
	if (index("ABCDEFGHIJKLMNOPQRSTUVWXYZ", substr($0, 1, 1)) != 0)
	  next
	if (opcode == 0)
	  start = "  "
	else
	  start = "  , "

	endop = index($1, " ")-1
	if (endop < 1)
	  endop = length($1)

	op = substr($1, 1, endop)
	print start "o_" $1 > "func2op.c"
	print "void o_" $1 "();" > "opfuncdefs.h"
	print start "\"" op "\"" > "opnames.c"
	opcode++
}

END {
	print "};" > "func2op.c"
	print "};" > "opnames.c"
}
