-- (C) Copyright International Business Machines Corporation 23 January
-- 1990.  All Rights Reserved.

-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 

-- Filename: time.d
-- Author: Andy Lowry
-- SCCS Info: @(#)time.d	1.3 9/11/90

-- Interface definitions for obtaining the current date and time in
-- various formats

time: using () definitions
  
  -- Months of the year
  month: ordered enumeration (
    'January', 'February', 'March', 'May', 'June',
    'July', 'August', 'September', 'October', 'November', 'December'
  );
  
  -- Days of the week
  dayOfWeek: ordered enumeration (
    'Sunday', 'Monday', 'Tuesday', 'Wednesday',
    'Thursday', 'Friday', 'Saturday'
  );
  
  -- Date and time info broken out into individual components
  dateAndTime: record (
    -- Primary information
    year: integer,
    month: month,
    day: integer,		-- range 1..31
    hour: integer,		-- range 0..23 (12M..11PM)
    minute: integer,		-- range 0..59
    second: integer,		-- range 0..59
    usecond: integer,		-- range 0..999999
    -- Auxiliary useful information
    dayOfWeek: dayOfWeek,
    dayOfYear: integer,		-- range 1..366
    secondOfEpoch: integer,	-- seconds since midnight 1/1/1970 GMT
    dstInEffect: boolean,	-- true if daylight savings time is in effect
    timezoneName: charstring,	-- abbreviation, e.g. EST for Eastern Std Time
    timezoneOffset: integer,	-- offset from GMT, in seconds east
    formattedTime: charstring	-- as in "Sun Sep 16 01:03:52 1973"
				-- (all fixed-width fields)
  );
  
  -- Interface to retrieve current date and time
  getCurrentTimeIntf: callmessage (
    dateAndTime: dateAndTime
  )
  exit {full};
  
  getCurrentTimeQ: inport of getCurrentTimeIntf {};
  
  getCurrentTimeFn: outport of getCurrentTimeQ;
  
end definitions

  
