-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: formaterrors.d
-- Author: David F. Bacon
-- SCCS Info: @(#)formaterrors.d	1.3 3/13/90

formatErrors: using (errors, absFormat, common, inferredtype, posmap)
definitions
    
  -- procedure to format a single compiler error message
  formatError: callmessage (
    error: error,
    -- support routines
    formatters: formatters,
    -- compilation context
    decls: scopes,
    infDecls: inferredDefinitions,
    defs: definitions_modules,
    defMap: definitions_printMappings,
    procMap: executable_printmap,
    positions: posMaps,
    -- formatted error message
    errMsg: charstring
  )
  constant
      (error, formatters, decls, infDecls, defs, defMap, procMap, positions)
  exit {full};
  formatErrorQ: inport of formatError {
    full(error), full(formatters), full(decls), full(infDecls), full(defs),
    full(defMap), full(procMap), full(positions) };
  formatErrorFn: outport of formatErrorQ;

  -- procedure to format a collection of compiler errors
  formatErrors: callmessage (
    errors: errors,
    -- support routines
    formatters: formatters,
    -- compilation context
    decls: scopes,
    infDecls: inferredDefinitions,
    defs: definitions_modules,
    defMap: definitions_printMappings,
    procMap: executable_printmap,
    positions: posMaps,
    -- formatted error messages
    errMsgs: charstringList
  ) 
  constant
      (errors, formatters, decls, infDecls, defs, defMap, procMap, positions)
  exit {full};
  formatErrorsQ: inport of formatErrors {
    full(errors), full(formatters), full(decls), full(infDecls), full(defs),
    full(defMap), full(procMap), full(positions) };
  formatErrorsFn: outport of formatErrorQ;
    
end definitions

