-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)coercions.d	1.2 3/13/90

-- this defines the coercion information passed from typestate checking to
-- code generation.  

coercions: USING (predefined, positions)

DEFINITIONS

Coercions: table of ProcessCoercions { full } keys (id);

processCoercions: record (
  Id: processid,		-- process for which we are giving coercion.
  PreCoercions: CoercionSet,	-- to lower typestate to meet precondition.
  PostCoercions: CoercionSet,	-- to soft-coerce after an alternative
				--  (block, if, select) statement.
  HandlerCoercions: ClauseCoercionSet
				-- to soft-coerce on entry to a handler.
);

CoercionSet: TABLE OF Coercion {full(*)} keys(Position);
Coercion: RECORD(
  Position: Aposition, -- identifies statement before/after which coercions will be inserted
  Coercions: Statements -- coercions inserted by ts checking
);

ClauseCoercionSet: TABLE OF ClauseCoercion {full(*)} keys(Clause);

ClauseCoercion: RECORD(
  Clause: ClauseId, -- identifies a clause in the program
  Coercions: Statements
);

END DEFINITIONS
