/* (C) Copyright International Business Machines Corporation 23 January  */
/* 1990.  All Rights Reserved.  */
/*   */
/* See the file USERAGREEMENT distributed with this software for full  */
/* terms and conditions of use.  */
/* SCCS Info: @(#)Makefile	1.32 1/6/92 */

DEFOBJS =	predefined.do checking_table.do  \
		inferredtype.do stdenv.do positions.do posmap.do \
		interpform.do listuff.do \
		errors.do typecheck.do \
		coercions.do filedef.do common.do cload.do \
		root.do main.do sysmain.do findfile.do pathload.do unix.do \
		unixint.do \
		pathreadobj.do load.do terminalio.do objectio.do \
		loadprogram.do storeprogram.do \
		codegen.do loadprog.do cwd.do \
		printobj.do type_inference.do typestate_inference.do \
		parse.do initparse.do unixstat.do annotate.do \
		initfindfile.do disassembler.do formaterror.do getfile.do \
		window.do cwindow.do fdhandlers.do profile.do absformat.do \
		typestate.do distributed.do safewindow.do safewindowinit.do \
		safewindowgen.do time.do crtoa.do \
		rmanager.do sysrmanager.do userrm.do stdio.do \
		main_options.do putfile.do check.do initcheck.do \
		personalrm.do chainedrm.do \
		fakechecked.do fakecheckeddefinitions.do

CDS	=	predefined.cd interpform.cd filedef.cd inferredtype.cd \
		cload.cd unix.cd load.cd objectio.cd codegen.cd \
		unixint.cd \
		loadprogram.cd storeprogram.cd \
		root.cd stdenv.cd printobj.cd coercions.cd posmap.cd \
		parse.cd initparse.cd unixstat.cd positions.cd \
		window.cd cwindow.cd fdhandlers.cd errors.cd profile.cd \
		listuff.cd distributed.cd time.cd crtoa.cd

TABLES	=	builtin_exception.table operator.table opcode.table

#include "includefile"

/* Set GENHROOT to something other than the floor system root in order to */
/* install into a new system tree (used by precompilerboot target in root */
/* make file) */

GENHROOT =	$(HROOT)
GENBIN =	$(GENHROOT)/bin

/* parameterize the .d.do rule so we can bootstrap with the standalone parser */
.d.do:	$<
	$(STANDALONE) $*$(DEFSUFFIX)
STANDALONE =
DEFSUFFIX =

all:	$(CDS) $(TABLES) compiledefs

install:	$(TABLES) install-cdfiles install-dofiles
install-cdfiles: cddir $(CDS)
	cp $(CDS) $(CDDIR)
install-dofiles: compiledefs
	cp $(DEFOBJS) $(GENBIN)

/* Following target runs 'fixdefs' on all the definitions modules, */
/* which may have been originally compiled without fixdefing.  The */
/* following kluge is used to make sure we fixdef things in the correct */
/* order: (1) move all the .do files to another temporary directory; */
/* (2) use 'make -n defobjs' to get the correctly ordered list of */
/* module names; (3) move the .do files back; and (4) run fixdefs */

fixdefs:
	@-rm -rf .dosave 2>/dev/null
	@mkdir .dosave
	@mv *.do .dosave
	@dlist=`make -n defobjs` ; echo $$dlist > .dlist
	@mv .dosave/?* .
	@rmdir .dosave
	@dlist=`cat .dlist` ; rm .dlist ; \
		echo $(ENV) $(HERMENV) $(HERMES) fixdefs $$dlist ; \
		$(ENV) $(HERMENV) $(HERMES) fixdefs $$dlist

boot:	$(CDS) $(TABLES)
	$(MAKE) defobjs HROOT=$(HROOT) MTYPE=$(MTYPE) \
		STANDALONE="$(ENV) $(HERMENV) $(HPARSE)" DEFSUFFIX=".d"

cdfiles: $(CDS)

cddir:
	@- if [ ! -d $(CDDIR) ] ; then mkdir $(CDDIR) ; fi

predefined.cd: predefined.d
	$(CHGRAM) predefined.d | \
	  sed -e '/char___ 95/ s/\(.*\)/\/\* \1 \*\//' >predefined.cd

opcodes.hd: greencard
	awk -f opcodes.awk greencard >opcodes.hd

interpform.d: interpform.dd opcodes.hd
	$(CPP) $(HCPPFLAGS) interpform.dd >interpform.d

annontate.do: annontate.d common.do

initparse.do: initparse.d load.do objectio.do cwd.do parse.do

unixstat.do: unixstat.d predefined.do unix.do

annotate.do: annotate.d predefined.do common.do

codegen.do: codegen.d predefined.do load.do unix.do annotate.do objectio.do \
		errors.do interpform.do

cwd.do: cwd.d predefined.do

objectio.do: objectio.d common.do

loadprog.do: loadprog.d objectio.do parse.do posmap.do

load.do: load.d predefined.do

terminalio.do: terminalio.d predefined.do

stdio.do: stdio.d terminalio.do

loadprogram.do: loadprogram.d load.do objectio.do predefined.do

storeprogram.do: storeprogram.d load.do objectio.do predefined.do

filedef.do: filedef.d parse.do

errors.do: errors.d predefined.do positions.do type_inference.do

parse.do: parse.d predefined.do posmap.do errors.do load.do

formaterror.do: formaterror.d predefined.do errors.do common.do absformat.do \
	inferredtype.do posmap.do

getfile.do: getfile.d predefined.do unix.do

posmap.do: posmap.d predefined.do positions.do

stdenv.do: stdenv.d predefined.do common.do terminalio.do objectio.do \
	load.do cwd.do

typecheck.do: typecheck.d predefined.do checking_table.do \
	inferredtype.do errors.do stdenv.do

coercions.do: coercions.d predefined.do positions.do

common.do: common.d predefined.do 

cload.do: cload.d predefined.do common.do

root.do: root.d predefined.do  cload.do common.do 

unix.do: unix.d predefined.do terminalio.do

unixint.do: unixint.d unix.do cload.do predefined.do

findfile.do: findfile.d common.do  unix.do

initfindfile.do: initfindfile.d findfile.do unix.do cwd.do

pathload.do: pathload.d stdenv.do findfile.do

pathreadobj.do: pathreadobj.d stdenv.do findfile.do

main.do: main.d common.do terminalio.do rmanager.do

sysmain.do: sysmain.d common.do terminalio.do sysrmanager.do

rmanager.do: rmanager.d common.do

sysrmanager.do: rmanager.do common.do

userrm.do: userrm.d rmanager.do sysrmanager.do

interpform.do: interpform.d predefined.do

listuff.do:	listuff.d interpform.do

inferredtype.do: inferredtype.d predefined.do

positions.do: positions.d predefined.do

checking_table.do: checking_table.d predefined.do type_inference.do \
	typestate_inference.do

type_inference.do: type_inference.d predefined.do

typestate_inference.do: typestate_inference.d predefined.do

libinit.do: libinit.d objectio.do load.do

printobj.do: printobj.d common.do

disassembler.do: disassembler.d predefined.do interpform.do stdenv.do

window.do: window.d predefined.do common.do stdenv.do cload.do terminalio.do

fdhandlers.do: fdhandlers.d predefined.do unix.do

cwindow.do: cwindow.d predefined.do unix.do

profile.do: profile.d predefined.do

absformat.do: absformat.d predefined.do inferredtype.do errors.do posmap.do

typestate.do: typestate.d stdenv.do coercions.do checking_table.do \
	inferredtype.do errors.do

distributed.do: distributed.d common.do

safewindow.do: terminalio.do

safewindowinit.do: safewindow.do cload.do main.do

safewindowgen.do: safewindow.do terminalio.do common.do

time.do: predefined.do

crtoa.do: predefined.do interpform.do

main_options.do: main_options.d predefined.do common.do annotate.do

putfile.do: putfile.d predefined.do unix.do

fakechecked.do: fakechecked.d predefined.do 

fakecheckeddefinitions.do: fakecheckeddefinitions.d predefined.do 

check.do: check.d predefined.do errors.do

initcheck.do: initcheck.d predefined.do terminalio.do rmanager.do check.do

personalrm.do: personalrm.d rmanager.do

chainedrm.do: chainedrm.d rmanager.do sysrmanager.do

/* tables of enumeration values */

opcode.table: interpform.d
	awk "`sed -e s/TYPENAME/opcode/ getenum.awk`" interpform.d \
		> opcode.table

operator.table: predefined.d
	awk "`sed -e s/TYPENAME/operator/ getenum.awk`" predefined.d \
		> operator.table

builtin_exception.table: predefined.d
	awk "`sed -e s/TYPENAME/builtin_exception/ getenum.awk`" predefined.d \
		> builtin_exception.table

/* */
/* cleanup */
/* */

clean::
	rm -f *.cd opcodes.hd interpform.d $(TABLES)
clean-dofiles:
	rm -f *.do
clean-cdfiles:
	rm -f *.cd
