-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: progfixfull.p
-- Author: David F. Bacon
-- SCCS Info: @(#)progfixfull.p	1.2 3/13/90

progfixfull: using (progFixFull, fixfull, type, inferredType)
  linking(findtype, fixfull) 
  
  process (q: progFixFullQ)
    
  declare
    args: progFixFull;
    findtype: findtypeCapa;
    fixfull: fixfullOutport;
    proc: proc;
    clause: clause;
    inferred: inferredDefinitions;
    stmtnum: integer;
    stmt: statement;
    typename: typename;
    
  begin
    findtype := procedure of process findtype;
    fixfull := procedure of process fixfull;
    
    new inferred;		-- fake up inferred type table

    receive args from q;

    for constproc in args.prog.programs[] inspect
	remove proc from args.prog.programs[constproc.id];
	    
	for constclause in proc.executable_part.clauses[] inspect
	    remove clause from proc.executable_part.clauses[constclause.id];
	    
	    stmtnum := 0;
	    while stmtnum < size of clause.statements repeat 
		block begin
		    -- inspect/exit hokiness to avoid runtime copy of table
		    inspect statement in clause.statements[stmtnum] begin
			if statement.operator <> 'unwrap' and
			       statement.operator <> 'inspect_polymorph' then
			    exit notypestate;
			  end if;
		      end inspect;
		    
		    remove stmt from clause.statements[stmtnum];
		    
		    if stmt.operator = 'unwrap' then
			typename := findtype(stmt.operands[1], 
			    proc.executable_part.scopes,
			    args.prog.definitions_modules, inferred);
			reveal stmt.qualifier.formal_typestate;
			call fixfull(args.prog.definitions_modules, typename, 
			    stmt.qualifier.formal_typestate);
		      else
			typename := findtype(stmt.operands[0],
			    proc.executable_part.scopes,
			    args.prog.definitions_modules, inferred);
			reveal stmt.qualifier.inspect_polymorph;
			call fixfull(args.prog.definitions_modules, typename, 
			    stmt.qualifier.inspect_polymorph.typestate);
		      end if;
		    
		    insert stmt into clause.statements at stmtnum;
		    
		  on exit (notypestate)
		    -- do nothing
		  end block;
	      end while;
	    
	    insert clause into proc.executable_part.clauses;
	    
	  end for;
	
	insert proc into args.prog.programs;

      end for;
    
    return args;
    
  end process
