-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: fixmin.p
-- Author: Rob Strom
-- SCCS Info: @(#)fixmin.p	1.4 1/7/91

-- Procedure to generate a minimum typestate given an exit typestate
-- 1. Create the formal attribute INIT(parent.component)
-- 2. If this is in the exit typestate, insert into minimum
--      and:
--    2.1. If parent.component is a record or callmessage, then
--         recursively invoke this procedure for each subcomponent

FixMin : USING( FixMin ) PROCESS ( FixMinInit : FixMinInport)
 DECLARE
    FP: FixMinCall ;
    FormalAttr: Formal_Attribute;
    Nothing: Empty;
    FormalObj: Component_List;
  BEGIN
    RECEIVE FP FROM FixMinInit;
    --1.
    NEW FormalAttr;
    UNITE FormalAttr.Attribute_Name.Init FROM Nothing;
    NEW FormalAttr.Parameters;
    FormalObj := FP.Parent;
    INSERT COPY OF FP.Component INTO FormalObj;
    INSERT COPY OF FormalObj INTO FormalAttr.Parameters;
    -- 2.
    IF EXISTS OF FA IN FP.ExitTS WHERE(FA = FormalAttr)
      THEN
        BLOCK
          DECLARE
            Self : FixMinOutport;
          BEGIN
            INSERT FormalAttr INTO FP.MinimumTS;
            -- 2.1.
            INSPECT PDotCDecl IN FP.Declarations WHERE(PDotCDecl.Id = FP.Component)
              BEGIN
                INSPECT PDotCModule IN FP.Definitions WHERE(PDotCModule.Id = PDotCDecl.Type.ModuleId)
                  BEGIN
                    INSPECT PDotCDefinition IN PDotCModule.Type_Definitions WHERE(PDotCDefinition.Id = PDotCDecl.Type.TypeId)
                      BEGIN
                        IF (CASE OF PDotCDefinition.Specification = 'recordtype') or (CASE OF PDotCDefinition.Specification = 'callmessagetype')
                          THEN
                            Self <- PROCEDURE OF CURRENTPROGRAM;
                            FOR Component IN PDotCDefinition.Component_Declarations WHERE('true')
                              INSPECT
                                CALL Self(Component.Id, FormalObj, PDotCDefinition.Component_Declarations, FP.Definitions, FP.ExitTS, FP.MinimumTS);
                              END FOR;
                          END IF;
                      END INSPECT;
                  END INSPECT;
              END INSPECT;
          on (NotFound)
            -- bogus PDotCDecl, PDotCModule, or PDotCDefinition
            -- checkdefs will catch this (I hope)
          END BLOCK;
      END IF;
    RETURN FP;
  END PROCESS
