-- This MUST be compiled so that the definitions module predefined is not
-- stripped.  I.e. pcom -keeppredef.

check: using(check, initcheck, common, terminalIO, rManager, errors, stdenv,
  parse, annotate,
  inferredType, typecheck, checking_table, typestate, coercions,
  codegen, interpform, fakechecked, listuff) 
linking(listuff, liunstuff)
process (init: initcheckQ)
declare
  initargs: initcheckintf;
  terminal: terminalIO!terminalFunctions;
  rm: rManager!rManager;
  checkin: checkQ;
  
  args: checkintf;
  predeftn: typename;
  
  stdenv: stdenv;
  die_disabled: boolean;
  errors: errors;
  checking_table: checking_table;
  typecheck: typecheckCapa;
  tsCheck: typestateCheckOutport;
  codegenInit: codegenInitFn;
  fakechecked: fakecheckedFn;
  listuff: listuffFn;
  liunstuff: liunstuffFn;

  die: signalQ;
begin
  receive initargs from init;
  terminal := initargs.terminal;
  rm := initargs.rm;
  new checkin;
  connect initargs.check to checkin;
  new die;
  connect initargs.finish to die;
  return initargs;
  
  -- Want to delay any real work until we know
  -- we need it, so we do a select first.  We need the disabled flag
  -- to ensure that the first time through the service loop we actually
  -- get the checkin event.
  select
  event checkin
    -- load the programs, below
  event die
    -- shut down checker
    exit done;
  otherwise
    -- this is SO BRAINDAMAGED!  I'm forced to include an otherwise 
    -- clause, but then typestate thinks it's a valid exit path,
    -- so now I have to put in an explicit exit
    exit canthappen;
  end select;
  
  -- build up a stdenv for compiler modules that were written with the
  -- old main interface in mind.  
  new stdenv;
  unwrap stdenv.load from rm.get("load", "") {init};
  unwrap stdenv.pathLoad from rm.get("pathLoad", "") {init};
  unwrap stdenv.readObj from rm.get("readObj", "") {init};
  unwrap stdenv.pathReadObj from rm.get("pathReadObj", "") {init};
  unwrap stdenv.writeObj from rm.get("writeObj", "") {init};
  unwrap stdenv.store from rm.get("store", "") {init};
  unwrap stdenv.libWriteObj from rm.get("libWriteObj", "") {init};
  unwrap stdenv.libStore from rm.get("libStore", "") {init};
  unwrap stdenv.getCwd from rm.get("getCwd", "") {init};
  unwrap stdenv.setCwd from rm.get("setCwd", "") {init};
  stdenv.terminal := terminal;
  
  -- could only get here if there is a checkin event waiting
  die_disabled <- 'true';
  typecheck <- procedure of stdenv.pathLoad("type");
  tsCheck <- procedure of stdenv.pathLoad("typestate");
  unwrap checking_table from stdenv.pathReadObj("checking_table.ho") {init};
  codegenInit <- procedure of stdenv.pathLoad("codegen");
  fakechecked <- procedure of stdenv.pathLoad("fakechecked");
  listuff <- create of process listuff;
  liunstuff <- create of process liunstuff;

  while ('true') repeat
    block
    declare
      prog: predefined!program;
      
      infDefs: inferredDefinitions;
      coercions: coercions;
      defMaps: Definitions_PrintMappings;
      procMaps: Executable_PrintMappings;
      annotes: annotations;
      annote: annotation;
      options: annotations;
      codegen: codegenFn;
      codemap: interpform!codeMap;
    begin
      select
      event checkin
	die_disabled <- 'false';
	receive args from checkin;
      event die and where (not die_disabled)
	-- shut down checker
	exit done;
      otherwise
	exit canthappen;
      end select;
      
      -- could only get here if we had a checkin event
      prog := args.p;
      
      --        call terminal.putstring("Checking Absprog");
      
      new args.errors;
      block begin
        -- toss in predefined if not already present.
        predeftn := \typename predefined!integer\;
        if not exists of prog.definitions_modules[predeftn.moduleid] then
	  block
	  declare
	    currprog: program;
	  begin
	    currprog <- currentprogram;
	    inspect predef in currprog.definitions_modules[predeftn.moduleid]
	    begin
	      insert copy of predef into prog.definitions_modules;
	    end inspect;
	  on (NotFound)
	    print charstring#"Whoa! predefined not found, and we needed it in check.p!!";
	    exit failed;
	  end block;
	end if;
      on (others)
        print charstring#"error in block 1 of check.p";
        exit die;
      end block;
      
      -- extract existing compiled programs from the absprog
      codeMap <- liunstuff(prog);

      -- do the equivalent of pcom (with no flags)
      block begin
        -- invoke type checker
	--        call terminal.putstring(" typecheck");
        
        new infDefs;
        for proc in prog.programs where
	      (not exists of codemap[proc.id]) inspect
	  block declare
	    newInfDefs: inferredDefinitions;
	  begin
	    call typeCheck(proc, prog.definitions_modules,
	      checking_table, stdenv, errors, newInfDefs);
	    merge newInfDefs into infDefs;
	  on (typeCheckCall.typeErrors)
	    -- add error messages to args.errors
	    for error in errors[] inspect
	      block declare
		procError: procError;
	      begin
		new procError;
		procError.procID := proc.id;
		procError.error := error;
		insert procError into args.errors;
	      end block;
	    end for;
	  end block;
	end for;
        -- raise exception if we've seen any errors
        if (size of args.errors <> 0) then
	  exit failed;
	end if;
	
        -- invoke typestate checker
	--        call terminal.putstring(" typestate");
        
        new defMaps;
        new procMaps;
        
        new coercions;
        for proc in prog.programs where
	      (not exists of codemap[proc.id]) inspect
	  block declare
	    newCoercions: coercions;
	  begin
	    call tscheck(stdenv, prog, proc, checking_table,
	      defMaps, procMaps, infDefs, newCoercions, errors);
	    merge newCoercions into coercions;
	  on (typestateCheckCall.typestateErrors)
	    -- add error messages to args.errors
	    for error in errors[] inspect
	      block declare
		procError: procError;
	      begin
		new procError;
		procError.procID := proc.id;
		procError.error := error;
		insert procError into args.errors;
	      end block;
	    end for;
	  end block;
	end for;
        -- raise exception if we've seen any errors
        if (size of args.errors <> 0) then
	  exit failed;
	end if;
        
      on (typestateCheckCall.discarded)
        print charstring#"discarded in block 2 of check.p";
        exit die;
      on (disconnected)
        print charstring#"disconnected in block 2 of check.p";
        exit die;
      on (duplicateKey)
        print charstring#"dup key in block 2 of check.p";
        exit die;
      on (others)
        print charstring#"error in block 2 of check.p";
        exit die;
      end block;
      
      block begin
        -- invoke code generator
        --        call terminal.putstring(" codegen");
        
        -- Construct annotations for the codegen process
        new annotes;
        
        new annote;
        annote.name <- "Module Name";
        wrap charstring#"absprog" as annote.thing;
        insert annote into annotes;
        
        new annote;
        annote.name <- "Inferred Definitions";
        wrap infDefs as annote.thing;
        insert annote into annotes;
        
        new annote;
        annote.name <- "Coercions";
        wrap coercions as annote.thing;
        insert annote into annotes;
        
        new annote;
        annote.name <- "Process Print Map";
        wrap (copy of procMaps) as annote.thing;
        insert annote into annotes;
        
        new annote;
        annote.name <- "Definitions Print Map";
        wrap (copy of defMaps) as annote.thing;
        insert annote into annotes;
        
      on (others)
        print charstring#"error in block 3 of check.p";
        exit die;
      end block;
      
      new options;

      codegen <- codegenInit(prog, annotes, options, 
	stdenv.pathLoad, stdenv.pathReadObj);

      for proc in prog.programs where
	    (not exists of codeMap[proc.id]) inspect
	block declare
	  code: interpform!prog;
	begin
	  call codegen(proc, code, errors);
	  insert (evaluate newentry: codemapEntry from
	      new newentry;
	      newentry.processid := proc.id;
	      newentry.liprog := code;
	    end) into codeMap;
	on (codegen.codegenErrors)
	  -- add error messages to args.errors
	  for error in errors[] inspect
	    block declare
	      procError: procError;
	    begin
	      new procError;
	      procError.procID := proc.id;
	      procError.error := error;
	      insert procError into args.errors;
	    end block;
	  end for;
	end block;
      end for;
      -- raise exception if we've seen any errors
      if (size of args.errors <> 0) then
	exit failed;
      end if;
      -- stuff the new code map into the absprog
      call listuff(prog, codeMap);
      -- sleeze in checked attribute.  
      call fakechecked(args.p);
      
      return args;
      
    on exit (failed)
      return args exception failure;
    end block;
    
  end while;
  
on (disconnected)
  --  print charstring#"check.p disconnected; goodbye...";
on (others)
  print charstring#"Whoa! unhandled exception in check.p!";
on exit (die)
  print charstring#"Should not occur; check.p dying";
on exit (canthappen)
  print charstring#"the impossible happened in check.p!";
on exit (done)
  
end process
