-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)fmttype.p	1.3 3/13/90

FmtType : USING(AbsFormat)
PROCESS (FormatTypeInit : FormatTypeInport )
-- procedure to format a typename
-- algorithm:  format the module name, a "!", then the type
  DECLARE
    FP: FormatTypeCall ;
  BEGIN
    RECEIVE FP FROM FormatTypeInit;
    BLOCK
      BEGIN
        INSPECT DefinitionMap IN FP.DefinitionsMap WHERE(DefinitionMap.Id = FP.Type.ModuleId)
          BEGIN
            FP.FormatValue := DefinitionMap.Name;
            INSERT '!' INTO FP.FormatValue;
            BLOCK
              BEGIN
                INSPECT TypeInfo IN DefinitionMap.Types WHERE(TypeInfo.Id = FP.Type.TypeId)
                  BEGIN
                    MERGE COPY OF TypeInfo.Name INTO FP.FormatValue;
                  END INSPECT;
              ON (NotFound)
                MERGE "??" INTO FP.FormatValue;
              END BLOCK;
          END INSPECT;
        ON (NotFound)
          FP.FormatValue := "??!??";
      END BLOCK;
    RETURN FP;
  END PROCESS
