-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)fmtattr.p	1.3 3/13/90

FmtAttr: USING(AbsFormat) 
PROCESS (FormatAttributeInit : FormatAttributeInport )
-- procedure to format an attribute
-- algorithm:  format the attributename as:
--   "(" comma-separated list of object names, ")"
  DECLARE
    FP: FormatAttributeCall ;
  BEGIN
    RECEIVE FP FROM FormatAttributeInit;
    FP.FormatValue <- FP.Formatters.FormatAttributeName(FP.Formatters, FP.Definitions, FP.DefinitionsMap, FP.Attribute.Name);
    INSERT '(' INTO FP.FormatValue;
    FOR Object IN FP.Attribute.Objects WHERE('true')
      INSPECT
        IF POSITION OF Object > 0
          THEN
            INSERT ',' INTO FP.FormatValue;
          END IF;
        MERGE FP.Formatters.FormatObject(FP.Formatters, FP.Declarations, FP.InferredDeclarations, FP.Definitions, FP.DefinitionsMap, FP.ExecutableMap, Object) INTO FP.FormatValue;
      END FOR;
    INSERT ')' INTO FP.FormatValue;
    RETURN FP;
  END PROCESS
