/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* File: printmap.ch */
/* Author: David F. Bacon */
#ifndef lint
static char sccsinfo[] = "@(#)printmap.ch	1.14 2/17/92";
#endif

#include <string.h>

#include "cherm.h"
#include "storage.h"

#include "resolve.h"
#include "stack.h"

#include "predefined.cd"
#include "parse.cd"
#include "resproc.cd"
#include "errors.cd"


#define INITIALIZED_ATTR "initialized"
#define INIT_ATTR        "init"
#define CASE_ATTR        "case"
#define CHECKED_ATTR     "checked"
#define CHECKEDDEF_ATTR  "checkeddefinitions"
#define FULL_ATTR        "full"

#define SCOPETABLE_SIZE  0
				/* was 4 */
#define EXECTABLE_SIZE   0
				/* was 2 */

typedef struct
{
    objectp pmap;
    stackp scope_stack;
} pmapenv;

static pmapenv *pmap_env;

stackp pmap_stack;

hobject(SDmaps,table);		/* definitions_printmappings */
hobject(SPmaps,table);		/* executable_printmappings */

hobject(SMmap,table);		/* module_printmap */
hobject(SCDmap,record);		/* definitions_printmap */
static objectp CPmap;		/* executable_printmap */

void
init_printmap()
{
    void bp_init();


    bp_init();

    avl_new_table(SDmaps, firstelem_key); /* keys (id) */
    avl_new_table(SPmaps, firstelem_key); /* keys (id) */
    avl2_new_table(SMmap,  firstandsecond_keyset); /* keys (name) (id) */
}


status
add_modulemap(Modname, Modid)
objectp Modname;		/* constant charstring */
objectp Modid;			/* constant moduleid */
{
    hobject(Entry,record);	/* module_printrec */


    new_record(Entry,module_printrec);
    copy(Entry@module_printrec__name, Modname);
    copy(Entry@module_printrec__id, Modid);

    if (insert(SMmap, Entry) is DuplicateKey) {
	fe_error(Inhibit_Codegen, errorcode__general_error,
		"Module '%s' is imported more than once", stringval(Modname));
	discard(Entry);
	return(FAILURE);
    }

    return(SUCCESS);
}


/* add the printmaps for an imported module.  this is called when we */
/* are in the direct_imports production. */

void
add_def_printmap(Defmap)
objectp Defmap;			/* in definitions_printmap */
{
    if (insert(SDmaps, Defmap) is DuplicateKey)
      fe_error(Fatal, errorcode__general_error,
	       "add_def_printmap",
	       "Duplicate printmaps that shouldn't be");
}


void
add_proc_printmaps(Procmaps)
objectp Procmaps;		/* in executable_printmappings */
{
    /* fix later: for each exec printmap, stuff it into the SPmaps */

    discard(Procmaps);
}


void
create_definitions_printmap(name, ModuleId)
char *name;			/* constant */
objectp ModuleId;		/* constant nominal */
{
    hobject(SName,charstring);
    hobject(STemp,record);


    chs_lit(SName,name);

    if (not add_modulemap(SName, ModuleId)) {
	discard(SName);		/* proceed with current module as "???" */
	chs_lit(SName, "???");
	(void) add_modulemap(SName, ModuleId);
				/* "???" is known to be unique. */
    }
    discard(SName);

    new_record(SCDmap, definitions_printmap);
    copy(SCDmap@Id, ModuleId);
    chs_lit(SCDmap@definitions_printmap__name,name);

    avl2_new_table(SCDmap@definitions_printmap__types, firstandsecond_keyset);
				/* keys (typeid) (name) */

    avl2_new_table(SCDmap@definitions_printmap__attributes, 
		  firstandsecond_keyset);
				/* keys (attrid) (name) */

    avl2_new_table(SCDmap@definitions_printmap__components, epmap_keyset);
				/* keys (type,component) (type,name) */

    avl2_new_table(SCDmap@definitions_printmap__exceptions, epmap_keyset);


    cheapcopy(STemp, SCDmap);
    add_def_printmap(STemp);
}


status
add_type_printname(name,Defid)
char *name;			/* constant string: name of the sucker. */
objectp Defid;			/* constant typeid */
{
    hobject(STyperec,record);


    new_record(STyperec,type_printrec);

    copy(STyperec@Id, Defid);
    chs_lit(STyperec@type_printrec__name, name);

    if (insert(SCDmap@definitions_printmap__types, STyperec) 
	is DuplicateKey) {
	fe_error(Inhibit_Codegen, errorcode__general_error,
		"Type '%s' was already defined in this module", name);
	discard(STyperec);
	return(FAILURE);
    }

    return(SUCCESS);
}


status
add_attr_printname(name,Def)
char *name;			/* constant string: name of the sucker. */
objectp Def;			/* constant attr_definition */
{
    hobject(SDefname,charstring);
    hobject(SAttrrec,record);


    chs_lit(SDefname,name);

    new_record(SAttrrec,attribute_printrec);
    copy(SAttrrec@Id, Def@Id);
    move(SAttrrec@type_printrec__name, SDefname);

    if (insert(SCDmap@definitions_printmap__attributes, SAttrrec) 
	is DuplicateKey) {
	fe_error(Inhibit_Codegen, errorcode__general_error,
		"Attribute '%s' was already defined in this module", name);
	discard(SAttrrec);
	return(FAILURE);
    }

    return(SUCCESS);
}


void
add_component_printname(name, Typeid, Compid)
char *name;			/* constant string: name of rootid */
objectp Typeid;			/* constant typeid */
objectp Compid;			/* constant componentid */
{
    hobject(SPrintrec, record);	/* component_printrec */

    new_record(SPrintrec, component_printrec);
    copy(SPrintrec@component_printrec__type, Typeid);
    copy(SPrintrec@component_printrec__component, Compid);
    chs_lit(SPrintrec@component_printrec__name, name);

    if (insert(SCDmap@definitions_printmap__components, SPrintrec) 
	is DuplicateKey) {
	fe_error(Inhibit_Codegen, errorcode__general_error,
		"Multiple declarations of component '%s'", name);
	discard(SPrintrec);
    }
}


objectp				/* out constant component_printrec */
resolve_component(Typename, name)
objectp Typename;		/* constant typename: type resolve against */
char *name;			/* constant string */
{
    hobject(SName,charstring);
    hobject(SCDefmap, record);	/* definitions_printmap */
    hobject(SCComprec, record);	/* component_printrec */
    objectp CComprec;		/* component_printrec */

    (void) h_lookup(SCDefmap, SDmaps, Typename@typename__moduleid, 0);

    chs_lit(SName, name);
    if (h_lookup_secondary(SCComprec,
			       SCDefmap@definitions_printmap__components, 
			       Typename@typename__typeid, SName, 0) 
	is NotFound)
      return(nil);
    else {
	CComprec = new_object();
	cheapcopy(CComprec, SCComprec);	
	return(CComprec);
    }
}


void
add_exception_printname(name, Typeid, Excepid)
char *name;			/* const string: name of exception */
objectp Typeid;			/* const typeid: callmsg type */
objectp Excepid;		/* const exceptionid: id of the exception */
{
    hobject(Erec, record);	/* exception_printrec */

    new_record(Erec, exception_printrec);
    copy(Erec@exception_printrec__type, Typeid);
    copy(Erec@exception_printrec__exception, Excepid);
    chs_lit(Erec@exception_printrec__name, name);

    if (insert(SCDmap@definitions_printmap__exceptions, Erec) 
	is DuplicateKey) {
	fe_error(Inhibit_Codegen, errorcode__general_error,
		 "Multiple occurrences of exception '%s'", name);
	discard(Erec);
    }
}


objectp
resolve_exception_printname(Typename, name)
objectp Typename;
char *name;
{
    char *pmap_type();

    hobject(Pmap, record);	/* definitions_printmap */
    hobject(Edef, record);	/* exception_printrec */
    hobject(Ename, charstring);
    objectp Eid;


    Eid = new_object();
    chs_lit(Ename, name);

    if ((h_lookup(Pmap, SDmaps,
		 Typename@typename__moduleid, 0) isnt Normal) or
	(h_lookup_secondary(Edef, Pmap@definitions_printmap__exceptions, 
			   Typename@typename__typeid, Ename, 0) isnt Normal)) {
	fe_error(Inhibit_Codegen, errorcode__general_error,
		 "'%s' is not an exception of type '%s'",
		 name, pmap_type(Typename));
	unique(Eid);		/* mock up a bogus value (fix later?) */
    }
    else
      copy(Eid, Edef@exception_printrec__exception);

    discard(Ename);
    return(Eid);
}



objectp
get_def_printmap()
{
    return(SDmaps);
}


objectp
get_prog_printmap()
{
    return(SPmaps);
}


objectp
get_mod_printmap()
{
    return(SMmap);
}


objectp
resolve_module(name)
char *name;			/* in string */
{
    hobject(SMap_Entry,record);	/* module_printrec */
    hobject(SName,charstring);


    chs_lit(SName, name);
    if (h_lookup(SMap_Entry, SMmap, SName, 0) is NotFound) {
	fe_error(Inhibit_Codegen, errorcode__general_error,
		"Module '%s' has not been imported", name);
	return(nil);
    }
    
    return(SMap_Entry@module_printrec__id);
}


status
module_in_printmap(Name)
object *Name;			/* constant charstring: name of module */
{
    lobject(Junk);

    if (h_lookup(Junk, SMmap, Name, 0) is Normal) 
      return(SUCCESS);
    else
      return(FAILURE);
}


qual_name *
p_qual_name(module, name)
char *module;			/* in string or nil */
char *name;			/* in string */
{	
    qual_name *newname;


    newname = tnew(qual_name);

    if (module)
      newname->moduleid = resolve_module(module);
    else
      newname->moduleid = nil;

    newname->name = name;


    return(newname);
}


objectp
p_type_or_attr_name(qname, typeflag)
qual_name *qname;
flag typeflag;			/* true if type; false if attribute */
{
    void add_unqualname();

    objectp get_defmodid();
    objectp resname_uar();
    objectp bp_type();		/* add type to backpatch table */
    char *pmap_module();
    objectp get_defmodid();

    hobject(SCMod, record);	/* definitions_printmap */
    hobject(SCMapEntry, record); /* type_printrec */
    hobject(SName, charstring);
    hobject(SEntry,record);	/* module_printrec */
    hobject(Eqmod, boolean);
    objectp Nextname;
    objectp Tora_name;
    objectp Defmodid;
    counter map_offset;
    int hits;
    flag backpatch;


    if (typeflag)
      map_offset = definitions_printmap__types;
    else
      map_offset = definitions_printmap__attributes;

    Defmodid = get_defmodid();
    backpatch = FALSE;
    Tora_name = nil;

    if (qname->moduleid) {	/* if the module name was specified... */
	if (h_lookup(SCMod, SDmaps, qname->moduleid, 0) is NotFound)
	  fe_error(Fatal, errorcode__general_error,
		   "p_type_or_attr_name",
		  "Resolved moduleid not found for '%s'", qname->name);

	chs_lit(SName, qname->name);
	if (h_lookup_secondary(SCMapEntry, SCMod@map_offset, SName, 0) 
	    is Normal) {	/* it's defined in a named module */
	    Tora_name = new_object();
	    new_record(Tora_name, typename);
	    copy(Tora_name@typename__moduleid, qname->moduleid);
	    copy(Tora_name@typename__typeid, SCMapEntry@Id);
	    return(Tora_name);
	}

	/* not found.  if the named module is the current module, backpatch */
	/* it.  otherwise, just give a not defined error. */

	if (Defmodid) {		/* if we are compiling a definitions module */
	    equal(Eqmod, Defmodid, SCMod@Id);
	    if (booleanval(Eqmod)) {
		backpatch = TRUE;
	    }
	}
    }
    else {			/* an unqualified name */
	initget(SEntry, SMmap, nil);
	hits = 0;
	backpatch = TRUE;

	while(get_or_err(SEntry, SMmap) is Normal) {
	    Nextname = resname_uar(SEntry, qname->name, map_offset);

	    if (Nextname isnt nil) {
		Tora_name = Nextname;
		backpatch = FALSE;
		hits++;
		if (hits > 1)
		  fe_error(Inhibit_Codegen, errorcode__general_error,
			   "%s name '%s' is defined in more than one module", 
			   map_offset is definitions_printmap__types ?
			     "Type" : "Attribute",
			   qname->name);
	    }
	}
	endget(SEntry, SMmap);
	if (hits is 1 and get_defmodid() isnt nil) 
				/* record all uses of unqualified names. */
	  add_unqualname(qname->name, typeflag);
    }

    if (Tora_name)		/* if we resolved it... */
      return(Tora_name);	/*  just return it. */

    /* either it was unqualified, or it was qualified with the name of the */
    /* current module.  if it still hasn't been resolved, backpatch it. */

    if (Defmodid and backpatch) { /* we are compiling a definitions module */
				/*  and should this be backpatched? */
	if (typeflag)
	  return(bp_type(qname->name, 0));
	else {
	    fe_error(Stop_Now, errorcode__general_error,
		     "I don't handle forward attribute references yet");
	    /*NOTREACHED*/
	}
    }
    else {			/* a process module, so it can't be a */
				/*  forward reference; give an error. */
	if (qname->moduleid)
	  fe_error(Stop_Now, errorcode__general_error,
		   "Type %s!%s is not defined", 
		   pmap_module(qname->moduleid), qname->name);
	else
	  fe_error(Stop_Now, errorcode__general_error,
		   "Type '%s' is not defined", qname->name);

	/*NOTREACHED*/
    }
}


objectp
resname_uar(Mprec, name, map_offset)
objectp Mprec;			/* constant module_printrec */
char *name;			/* constant string */
counter map_offset;		/* constant definitions_printmap__types or definitions_printmap__attributes */
{
    hobject(SCMod, record);	/* definitions_printmap */
    hobject(SCMapEntry, record); /* type_printrec or attr_printrec */
    hobject(SName, charstring);
    objectp Tora_name;
    
    
    if (h_lookup(SCMod, SDmaps, Mprec@module_printrec__id, 0) is NotFound)
      fe_error(Fatal, errorcode__general_error,
	       "resname_uar",
	       "Resolved moduleid not found for '%s'", name);

    chs_lit(SName,name);
    if (h_lookup_secondary(SCMapEntry, SCMod@map_offset, SName, 0) 
	is NotFound) {
      discard(SName);
      return(nil);		/* didn't find it in this module */
    }
    discard(SName);
    Tora_name = new_object();
    new_record(Tora_name, typename); /* create type or attribute name record */
    copy(Tora_name@typename__moduleid, Mprec@module_printrec__id);
    copy(Tora_name@typename__typeid, SCMapEntry@Id);
    return(Tora_name);
}


objectp
p_attr_info(qname)
qual_name *qname;
{
    objectp Attrinfo;		/* attribute_info */


    /* fix later: handle FULL, fix rob's */
    /* bogus method of representing case attribute in absprog */

    Attrinfo = new_object();

    if (strcmp(qname->name, INITIALIZED_ATTR) is 0 or 
	strcmp(qname->name, INIT_ATTR) is 0) {
	unite(Attrinfo, Bottom, attribute_type__initialized);
	return(Attrinfo);
    }

    if (strcmp(qname->name, CASE_ATTR) is 0) {
	unite(Attrinfo, Bottom, attribute_type__case);
	return(Attrinfo);
    }

    if (strcmp(qname->name, CHECKED_ATTR) is 0) {
       unite(Attrinfo, Bottom, attribute_type__checked);
       return(Attrinfo);
    }
    if (strcmp(qname->name, CHECKEDDEF_ATTR) is 0) {
       unite(Attrinfo, Bottom, attribute_type__checkeddefinitions);
       return(Attrinfo);
    }
    if (strcmp(qname->name, FULL_ATTR) is 0) {
	unite(Attrinfo, Bottom, attribute_type__full);
	return(Attrinfo);
    }

    unite(Attrinfo, p_type_or_attr_name(qname, FALSE), 
	  attribute_type__constraint);
    return(Attrinfo);
}


objectp				/* out constant definitions printmap */
lookup_module_pmap(Moduleid)
objectp Moduleid;		/* constant moduleid */
{
    objectp CMap;		/* definitions_printmap */

    CMap = new_object();

    if (h_lookup(CMap, SDmaps, Moduleid, 0) isnt Normal)
      fe_error(Fatal, errorcode__general_error,
	       "lookup_module_pmap",
	       "Can't resolve moduleid to printname");

    return(CMap);
}


char *				/* out constant string: module name */
pmap_module(Moduleid)
objectp Moduleid;
{
    objectp CMap;		/* definitions_printmap */
    char *name;


    CMap = lookup_module_pmap(Moduleid);
    name = stringval(CMap@definitions_printmap__name);
    return(name);
}


char *
pmap_type_or_attr(Typename, typeflag)
objectp Typename;
flag typeflag;			/* true: typename; false: attrname */
{
    objectp CMap;		/* definitions_printmap */
    objectp CTyperec;		/* type_printrec */
    char *modname;
    char *typename;
    char *name;
    counter map_offset;


    map_offset = typeflag ? definitions_printmap__types : 
      definitions_printmap__attributes;

    CMap = lookup_module_pmap(Typename@typename__moduleid);

    CTyperec = new_object();
    if (h_lookup(CTyperec, CMap@map_offset, Typename@typename__typeid, 0)
	isnt Normal)
      fe_error(Fatal, errorcode__general_error,
	       "pmap_type",
	       "Can't find printname for resolved %s",
	       typeflag ? "type" : "attribute");

    typename = stringval(CTyperec@type_printrec__name);
    modname = pmap_module(Typename@typename__moduleid);
    name = tempalloc(strlen(modname)+strlen(typename)+2);
    (void) strcpy(name, modname);
    (void) strcat(name, "!");
    (void) strcat(name, typename);


    return(name);
}


char *
pmap_type(Typename)
objectp Typename;
{
    return(pmap_type_or_attr(Typename, TRUE));
}


char *
pmap_attribute(Attributename)
objectp Attributename;
{
    return(pmap_type_or_attr(Attributename, FALSE));
}


char *
pmap_attribute_info(Attrinfo)
objectp Attrinfo;
{
    switch (obj_case_of(Attrinfo)) {
      case attribute_type__initialized:
	return("Initialized");

      case attribute_type__case:
	return("Case");

      case attribute_type__full:
	return("Full");

      case attribute_type__constraint:
	return(pmap_attribute(Attrinfo@Component));
    }

    fe_error(Fatal, errorcode__general_error,
	     "pmap_attribute_info",
	     "Non-existant case type number %u encountered", 
	   obj_case_of(Attrinfo));
    /*NOTREACHED*/
}



void
init_exec_printmap()
{
    stack_create(&pmap_stack);
}



void
create_exec_printmap(Execid, modulename)
objectp Execid;			/* constant executable_id */
char *modulename;		/* constant string */
{
    hobject(SPmaptemp, record);

    /* create the process printmap */

    CPmap = new_object();
    new_record(CPmap, executable_printmap);
    copy(CPmap@Id, Execid);
    chs_lit(CPmap@executable_printmap__name, modulename);
    avl2_new_table(CPmap@executable_printmap__roots, epmap_keyset);
    avl2_new_table(CPmap@executable_printmap__exits, firstandsecond_keyset);

    cheapcopy(SPmaptemp, CPmap);
    insert(SPmaps, SPmaptemp);

    pmap_env = tnew(pmapenv);
    stack_create(&pmap_env->scope_stack);
    pmap_env->pmap = CPmap;
    stack_push(&pmap_stack, pmap_env);
}


void
end_exec_printmap()
{
    pmapenv *oldenv;

    oldenv = pmap_env;
    (void) stack_pop(&pmap_stack);
    if (pmap_stack) {
	pmap_env = (pmapenv *) stack_top(&pmap_stack);
	CPmap = pmap_env->pmap;
    }
}


void
pmap_push_scope(Scope)
objectp Scope;
{
    stack_push(&pmap_env->scope_stack, Scope);
}

void
pmap_pop_scope()
{
    stack_popndrop(&pmap_env->scope_stack);
}



void
add_root_printname(name,Rootid)
char *name;			/* constant string: name of object */
objectp Rootid;			/* constant rootid: its uniqueid */
{
    objectp get_scope_id();

    lobject(SRoot);


    new_record(SRoot, root_printrec);
    copy(SRoot@root_printrec__scope, get_scope_id());
    copy(SRoot@root_printrec__root, Rootid);
    chs_lit(SRoot@root_printrec__name, name);

    if (insert(CPmap@executable_printmap__roots, SRoot) isnt Normal) {
	discard(SRoot);
	fe_error(LASTPHASE, errorcode__general_error,
		 "Name '%s' has already been used in this scope",
		 name);
    }
}


void
check_occlusion(name, scopestack)
char *name;			/* constant string: name of declaration */
stackp scopestack;		/* constant stack: stack of current scopes */
{
    lobject(Objname);		/* charstring */
    lobject(Mapentry);		/* root_printrec */
    objectp Scope;		/* scope */


    chs_lit(Objname, name);

    for (Scope = stack_next(&scopestack); Scope isnt nil; 
	 Scope = stack_next(&scopestack))
      if (h_lookup_secondary(Mapentry, CPmap@executable_printmap__roots,
			     Scope@Id, Objname, 0) is Normal) {
	  fe_error(LASTPHASE, errorcode__general_error,
		   "Name '%s' has already been used in an enclosing scope",
		   name);
	  discard(Objname);
	  return;
      }

    discard(Objname);
}



objectp
resolve_rootname(name)
char *name;			/* constant string: object name */
{
    stackp entry;
    objectp Scope;
    hobject(SName, charstring);
    hobject(SPrintrec, record);	/* root_printrec */
    objectp Rootname;		/* rootname */
    int i;

    chs_lit(SName, name);

    /* yes, boys and girls, it's time to violate the data abstraction */

    for (entry = pmap_env->scope_stack; entry isnt nil; entry = cdr(entry)) {
	Scope = entry->value;

	if (h_lookup_secondary(SPrintrec, CPmap@executable_printmap__roots,
				   Scope@Id, SName) is Normal) {
	    Rootname = new_object();
	    new_record(Rootname, rootname);
	    copy(Rootname@rootname__scope, SPrintrec@root_printrec__scope);
	    copy(Rootname@rootname__root, SPrintrec@root_printrec__root);

	    discard(SName);
	    return(Rootname);
	}
    }

    fe_error(Stop_Now, errorcode__general_error,
	     "Root name '%s' is undefined", name);
    /*NOTREACHED*/
}



/*
 * exits 
 */


objectp
exit_reference(name)
char *name;
{
    hobject(Exitrec, record);
    hobject(Ename, charstring);
    objectp Exitid;


    chs_lit(Ename, name);
    Exitid = new_object();

    if (h_lookup_secondary(Exitrec, CPmap@executable_printmap__exits, Ename, 0)
	is NotFound) {
	new_record(Exitrec, exit_printrec);
	unique(Exitrec@exit_printrec__exit);
	move(Exitrec@exit_printrec__name, Ename);
	copy(Exitid, Exitrec@exit_printrec__exit);
	(void) insert(CPmap@executable_printmap__exits, Exitrec);
    }
    else
      copy(Exitid, Exitrec@exit_printrec__exit);

    return(Exitid);
}


objectp
exit_handler(name)
char *name;
{
    hobject(Exitrec, record);
    hobject(Ename, charstring);
    objectp Exitid;


    /* fix later:? detect exits used but never "defined" */

    chs_lit(Ename, name);

    if (h_lookup_secondary(Exitrec, CPmap@executable_printmap__exits, Ename, 0)
	is NotFound) {
	fe_error(Inhibit_Codegen, errorcode__general_error,
		 "Exit '%s' is never used", name);
	return(exit_reference(name));
    }
    
    Exitid = new_object();
    copy(Exitid, Exitrec@exit_printrec__exit);

    return(Exitid);
}
