/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* File: lookup.ch */
/* Author: David F. Bacon */
#ifndef lint
static char sccsinfo[] = "@(#)lookup.ch	1.7 2/17/92";
#endif

#include "cherm.h"
#include "storage.h"

#include "resolve.h"

#include "predefined.cd"
#include "errors.cd"


static objectp			/* out constant definitions_module */
lookup_module(Moduleid)
objectp Moduleid;		/* constant moduleid */
{
    objectp CModule;		/* definitions_module */

    CModule = new_object();
    if (h_lookup(CModule, Absprog@program__definitions_modules, 
	Moduleid, 0) isnt Normal)
      fe_error(Fatal, errorcode__general_error,
	       "lookup_module", 
	       "Can't find resolved module id");

    return(CModule);
}



objectp				/* out constant type_definition */
lookup_typename(Tname)
objectp Tname;			/* constant typename */
{
    objectp CModule;		/* definitions_module */
    objectp CDef;		/* type_definition */

    CModule = lookup_module(Tname@typename__moduleid);

    CDef = new_object();

    if (h_lookup(CDef, CModule@definitions_module__type_definitions,
		     Tname@typename__typeid, 0)
	is NotFound) {
	CDef = nil;		/* it's a forward definition */
    }

    return(CDef);
}


objectp				/* out constant component_declaration */
lookup_component_declaration(Typename, Componentid)
objectp Typename;		/* constant type_name */
objectp Componentid;		/* constant componentid */
{
    objectp CDef;		/* type_definition */
    objectp CDecl;		/* component_declaration */


    CDef = lookup_typename(Typename);

    if (CDef) {
	CDecl = new_object();
				/* 1.2: don't use lookup_secondary(): */
	if (h_lookup(CDecl, CDef@type_definition__component_declarations,
		     Componentid, 0) is NotFound) {
	    fe_error(LASTPHASE, errorcode__general_error,
		     "problems in lookup_component, mate");
	    CDecl = nil; 
	}
	return(CDecl);
    }
    else {
	fe_error(LASTPHASE, errorcode__general_error,
		 "lookup failed for component's type definition");
	return(nil);
    }
}


objectp
lookup_object_typename(Objname)
objectp Objname;		/* constant objectname */
{
    objectp get_proc();

    objectp Typename;		/* typename */
    objectp Curtype;		/* typename */
    objectp Curproc;		/* proc */
    objectp Defmods;		/* definitions_modules */
    hobject(Scope, record);	/* scope */
    hobject(Decl, record);	/* declaration */
    hobject(Compid, nominal);	/* componentid */
    hobject(Defs, table);	/* type_definitions */
    hobject(Def, record);	/* type_definition */
    hobject(Cdef, record);	/* component_declaration */


    Curproc = get_proc();	/* establish resolution environment */
    Defmods = Absprog@program__definitions_modules;

    if ((h_lookup(Scope,
		 Curproc@proc__executable_part@execution_environment__scopes,
		 Objname@objectname__root@rootname__scope, 0) isnt Normal) or
	(h_lookup(Decl, Scope@scope__declarations, 
		  Objname@objectname__root@rootname__root, 0) isnt Normal)) {
	fe_error(LASTPHASE, errorcode__general_error,
		 "Can't find declaration for resolved objectname");
	return(nil);
    }

    if (obj_case_of(Decl@declaration__typename) is typename_option__unnamed) {
      fe_error(LASTPHASE, errorcode__general_error,
	       "lookup_object_typename failed: tried to look up type of a temporary");
	return(nil);
    }

    Curtype = Decl@declaration__typename@Component;
				/* get typename of root object */

    initget(Compid, Objname@objectname__components, nil);

    while(get_or_err(Compid, Objname@objectname__components) is Normal) {
	if ((h_lookup(Defs, Defmods, Curtype@typename__moduleid, 0) 
	     isnt Normal)
	    or (h_lookup(Def, Defs@definitions_module__type_definitions,
			 Curtype@typename__typeid, 0)) isnt Normal) {
	    fe_error(LASTPHASE, errorcode__general_error,
		     "Can't find definition for resolved type");
	    return(nil);
	}

	if (h_lookup(Cdef, Def@type_definition__component_declarations, 
		     Compid, 0) isnt Normal) {
	    fe_error(LASTPHASE, errorcode__general_error,
		     "Can't find component definition for resolved objectname");
	    return(nil);
	}

	Curtype = Cdef@component_declaration__type;
    }

    Typename = new_object();
    copy(Typename, Curtype);
    return(Typename);
}



objectp 
lookup_element_typename(Objname)
objectp Objname;			/* typename */
{
    char *pmap_type();

    objectp CDef;
    objectp Eltname;
    objectp Retval;
    objectp Tname;


    Tname = lookup_object_typename(Objname);
    CDef = lookup_typename(Tname);

    if (obj_case_of(CDef@type_definition__specification) isnt 
	primitive_types__tabletype) {
	fe_error(Stop_Now, errorcode__general_error,
		 "Non-table '%s' used in selector",
		 pmap_type(Tname));
	/*NOTREACHED*/
    }

    Eltname =
      CDef@type_definition__specification@Component@table_info__element_type;

    Retval = new_object();
    copy(Retval, Eltname);
    return(Retval);
}
