# (C) Copyright International Business Machines Corporation 23 January 
# 1990.  All Rights Reserved. 
#  
# See the file USERAGREEMENT distributed with this software for full 
# terms and conditions of use. 
# SCCS Info: @(#)keywords.awk	1.2 3/13/90
#
# this awk script takes a file of keywords as input and produces 
# a set of lex rules which recognize each keyword in the input file
# in mixed case, and has the simple action of returning the appropriate
# token value (for instance, recognizing the token "IF" causes the action
# "return(T_IF);").
#
BEGIN { 				# alphabet strings for case conversion
  uc = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
  lc = "abcdefghijklmnopqrstuvwxyz"
}
#
# main code, done for all lines that aren't comments
#
/^[A-Z]+$/ {
  x = ""				# initialize output string to null
  for ( i = 1; i <= length($1); i++) {	# loop over chars of keyword
     ch = substr($1, i, 1)		#  extract character
     lch = substr(lc, index(uc, ch), 1)	#  convert to lower case
     x = x "[" ch lch "]"		#  "i" gets converted to "[Ii]"
  }
  print x , "Treturn(" $1 ");"
}
