/* (C) Copyright International Business Machines Corporation 23 January  */
/* 1990.  All Rights Reserved.  */
/*   */
/* See the file USERAGREEMENT distributed with this software for full  */
/* terms and conditions of use.  */
/* File: Makefile */
/* Author: David F. Bacon */
/* SCCS Info: @(#)Makefile	1.26 2/7/92 */

#include "includefile"

/* Some yaccs have trouble with our grammar... for those, we'll just */
/* keep the yacc output files that came with the distribution instead of */
/* regenerating them */
#if defined(_MTYPE_bsdrt) || defined(_MTYPE_convex)
#define BADYACC
#endif

/* redefine default lex to binary rule so that it keeps the lex source */
/*   around just in case we fall into it while debugging. */
.l.o:
	$(LEX) $<
	$(CC) $(CFLAGS) -c lex.yy.c
	mv lex.yy.o $@

/* Set following to "/usr/lib/debug/malloc.o" to load in malloc_debug support */
MALLOCDEBUG =
LIBS	=	$(LIBDIRS) $(MALLOCDEBUG) -lfe -lcherm -lhermi -ll -lhaux \
		$(MACHLIBS)

CHLIBS	=	-ll

LINTLIBS =	-lhaux -lhasm -lhermi -lcherm

#ifdef _MTYPE_bsdrt
YACC	=	bigyacc
#else
YACC	=	yacc
#endif

#if defined(_MTYPE_sun3) || defined(_MTYPE_sun4) || defined(_MTYPE_sun3_nodl) || defined(_MTYPE_sun4_nodl) || defined(_MTYPE_hpux)
YFLAGS	=	-v -d -Nm50000
#else
YFLAGS	=	-v -d
#endif

LIBOBJS	=	main.o resolve.o definition.o module.o decl.o \
		process.o unqualname.o typestate.o \
		printmap.o main.o backpatch.o objname.o lookup.o \
		fegram.o felex.o stack.o tempstore.o links.o

IOOBJS	=	standalone.o integrated.o

OBJECTS	=	$(LIBOBJS) $(IOOBJS)

all:		hparse integrated.o chgram

install:	all install-chgram
	cp hparse $(HPARSE)

install-chgram:	chgram
	cp chgram $(CHGRAM)

libfe.a: $(LIBOBJS)
	ar r libfe.a $?
	$(RANLIB) libfe.a

hparse: standalone.o libfe.a stubs.o $(HROOT)/li/libhermi.a \
		$(HROOT)/cherm/libcherm.a $(HROOT)/lib/libhaux.a
	$(CC) $(CFLAGS) -o hparse standalone.o stubs.o $(LIBS)

/* yacc-ity yacc, don't talk back.... */

tokens.yacc: keywords othertokens
	cat othertokens keywords | awk -f tokens.awk >tokens.yacc

keywords.lex: keywords
	awk -f keywords.awk keywords >keywords.lex

ident.yacc: keywords reswords
	egrep -v `awk -f reswords.awk reswords` keywords | \
	  awk -f ident.awk >ident.yacc
 
felex.l: felex.lex felex.h keywords.lex othertokens
	m4 felex.lex >felex.l
	
felex.c: felex.l
	lex -t felex.l >felex.c

/* */
/* the grammar */
/* */
fegram.y: fegram.yacc ident.yacc opt.yacc series.yacc kleene.yacc \
    list.yacc tokens.yacc 
	m4 fegram.yacc >fegram.y

#ifdef BADYACC
fegram.c tokens.h: fegram.y
	touch fegram.c tokens.h
#else
fegram.c tokens.h: fegram.y
	$(YACC) $(YFLAGS) fegram.y
	mv y.tab.c fegram.c
	mv y.tab.h tokens.h
#endif

/* */
/* resolution */
/* */
printmap.c: printmap.ch resolve.h resproc.cd stack.o
objname.c: objname.ch resolve.h
definition.c: definition.ch resolve.h
module.c: module.ch resolve.h 
decl.c: decl.ch resolve.h backpatch.cd
typestate.c: typestate.ch resolve.h
process.c: process.ch resolve.h stack.o resproc.cd
backpatch.c: backpatch.ch resolve.h backpatch.cd
lookup.c: lookup.ch resolve.h 
unqualname.c: unqualname.ch unqualname.cd resolve.h
links.c: links.ch

integrated.c: integrated.ch unixenv.h
standalone.c: standalone.ch unixenv.h

/* */
/* chgram'd local defintions */
/* */
backpatch.cd: backpatch.d
resproc.cd: resproc.d
unqualname.cd: unqualname.d


/* test for true correctness */
lint: fegram.o felex.o $(RESOBJS)
	$(LINT) $(LFLAGS) *.c

/* cleanup */
/* */
/* the version of the front end which builds definitions for the assembler */
/* */

chgram.y: chgram.yacc ident.yacc opt.yacc series.yacc kleene.yacc \
    list.yacc tokens.yacc 
	m4 chgram.yacc >chgram.y


#ifdef BADYACC
chgram.c: chgram.y
	touch chgram.c tokens.h
#else
chgram.c: chgram.y
	$(YACC) $(YFLAGS) chgram.y
	mv y.tab.c chgram.c
	mv y.tab.h tokens.h
#endif

chgram: chgram.o felex.o chmain.o 
	$(CC) $(CFLAGS) -o chgram chmain.o chgram.o felex.o $(CHLIBS)

/* */
/* old debugging stuff */
/* */
readstamp: readstamp.o
	$(CC) $(CFLAGS) -o readstamp readstamp.o -lhermi -lcherm -lhaux-f

readstamp.c: readstamp.ch

/* Make sure teh most recent versions of the yacc output files are */
/* checked in in this directory, so they'll be part of the distribution */
/* (some yacc's aren't capable of generating them) */
package: fegram.c chgram.c tokens.h
	- cp $(HROOT)/update_sccs $(BINDIR)
	- chmod +x $(BINDIR)/update_sccs
	$(BINDIR)/update_sccs fegram.c chgram.c tokens.h
	rm -f $(BINDIR)/update_sccs	

clean::
	rm -f lex.yy.c y.tab.c felex.l keywords.lex hparse y.output \
		tokens.yacc tokens.include ident.yacc fegram.y felex.c \
		printmap.c objname.c definition.c name.c module.c \
		decl.c typestate.c process.c backpatch.c lookup.c links.c \
		unqualname.c integrated.c standalone.c \
		chgram chgram.y

/* on systems whose yacc can't cut it, don't mess with the yacc output */
/* that came with the distribution */

#ifndef BADYACC
clean::
	rm -f chgram.c fegram.c tokens.h
#endif
