-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
disassembler: using (predefined,interpform,disassembler,listuff,disinternal, 
  common)
linking (disoperation, disopcode, disoperand, disqualifier, disinteger, 
  disblanks)

  process (Q: disassemblerQ)
  declare
    args: disassembler!disassembler;
    qualifier: interpform!qualifier;
    dis: dis;
    procnames: procnames;
    temp: interpform!qualifier;
    prog: interpform!prog;
  begin
    receive args from Q;
    -- load the pieces of the disassembler
    new dis;
    dis.pms := args.printmaps;
    dis.operation <- procedure of process disoperation;
    dis.opcode <- procedure of process disopcode;
    dis.operand <- procedure of process disoperand;
    dis.qualifier <- procedure of process disqualifier;
    dis.integer <- procedure of process disinteger;
    dis.blanks <- procedure of process disblanks;
    -- Create import list
    args.code <- args.modulename | ": using ( ";
    for module in dis.pms.defs[]
    inspect
      merge (copy of module.name) into args.code;
      insert ' ' into args.code;
    end for;
    insert ')' into args.code;
    insert 'NL' into args.code;
    new procnames;
    for mapentry in args.codeMap[] inspect
      prog := mapentry.liprog;
      block declare
	basename: charstring;
	counter: integer;
	procname: procname;
      begin
	new procname;
	new basename;
	for c in prog.name[] inspect
	  if ((c >= 'A' and c <= 'Z') 
		  or (c >= 'a' and c <= 'z') 
		  or (c >= '0' and c <= '9')) then
	    insert copy of c into basename;
	  else
	    insert '_' into basename;
	  end if;
	end for;
	if (size of basename = 0) then
	  procname.name := args.modulename;
	else
	  procname.name := basename;
	end if;
	counter <- 1;
	while exists of entry in procnames where
	      (entry.name = procname.name) repeat
	  procname.name := basename | dis.integer(counter);
	  counter <- counter + 1;
	end while;
	procname.id := mapentry.processid;
	insert procname into procnames;
      end block;
    end for;

    for mapentry in args.codemap[] inspect
      prog := mapentry.liprog;
      unite dis.pms.progid.pid from copy of mapentry.processid;
      if (mapentry.processid = args.main_program) then
	merge "main " into args.code;
      end if;
      new dis.label;
      inspect p in procnames[mapentry.processid] begin
	dis.label.prog_name := p.name;
      end inspect;
      dis.label.line_base := "LI";
      dis.label.label_base := dis.label.prog_name;
      dis.label.exit_base := dis.label.prog_name | "_exit";
      -- determine largest possible indentation;
      block declare
	max_digits: integer;
	max_line: integer;
	max_label: integer;
      begin
	max_digits <- size of dis.integer(size of prog.code);
	max_line <- size of charstring#"/**/ " 
	    + size of dis.label.line_base + max_digits;
	max_label <- size of charstring#": "
	    + size of dis.label.label_base + max_digits;
	if max_line > max_label then
	  dis.label.max_blanks <- max_line;
	else
	  dis.label.max_blanks <- max_label;
	end if;
      end block;
      -- indentation was important when the liprog was a recursive
      -- structure, but now it's pretty stupid looking.
      dis.label.indentation <- 0;
      -- these two fields are modified during disassembly
      new dis.label.exits;
      new dis.label.dests;
      -- create prolog for this process
      merge "process " | dis.label.prog_name | " " into args.code;
      unite temp.typename from copy of prog.type;
      merge dis.qualifier(dis,temp,'noop', procnames) into args.code;
      merge " " | dis.integer(prog.size) into args.code;
      insert 'NL' into args.code;
      -- generate the code;
      block declare
	code: source;
      begin
	new code;
	for operation in prog.code[] inspect
	  insert dis.operation(dis, operation, procnames) into code;
	end for;
	block declare
	  label: charstring;
	  skipcount: integer;
	begin
	  skipcount <- 0;
	  for line in code[] inspect
	    -- label this line if it needs it
	    if exists of dis.label.dests[position of line] then
	      unite temp.integer from position of line;
	      label <- dis.qualifier(dis,temp,'branch',procnames) | ":";
	      merge dis.blanks(dis.label.max_blanks - size of label)
		  into label;
	    else
	      if skipcount = 0 then
		unite temp.integer from position of line;
		label <- "/*" | dis.label.line_base
		    | dis.qualifier(dis,temp,'noop',procnames) | "*/";
		merge dis.blanks(dis.label.max_blanks - size of label)
		    into label;
	      else
		label <- dis.blanks(dis.label.max_blanks);
	      end if;
	    end if;
	    merge label | line into args.code;
	    insert 'NL' into args.code;
	    if (skipcount = 0) then
	      skipcount <- 4;
	    else
	      skipcount <- skipcount - 1;
	    end if;
	  end for;
	  merge "end" into args.code;
	  insert 'NL' into args.code;
	end block;
      end block;
    end for;
    return args;
  on (disoperation.Unsupported, disqualifier.Unsupported)
    return args exception Unsupported;
  end process
   

