-- (C) Copyright International Business Machines Corporation 16 September
-- 1991.  All Rights Reserved.
--
-- See the file USERAGREEMENT distributed with this software for full
-- terms and conditions of use.
-- SCCS Info: @(#)chupstate.p	1.2 2/4/92

chupstate: using(chphase3, chtransform, interpform)

  process(Q: upstateQ)
    
  declare
    
    cm: upstate;
    pos: integer;
    ix: integer;
    statement: ch_statement;
    stixs: statement_indices;
    reference: referenceFn;
    junk: boolean;
    
  begin
    
    receive cm from Q;
    
    -- update all interpreted statement positions (including escapes)
    ix <- 0;
    new stixs;
    for st in cm.statements[] inspect
	pos <- position of st;
	if st.locus <= 'escape' 
	      or (st.locus = 'omit' and st.opcode = 'escape') then
	    remove statement from cm.statements[pos];
	    statement.position := ix;
	    insert statement into cm.statements at pos;
	    ix <- ix + 1;
	  end if;
	if st.flow < 'emerge' then
	    if st.flow = 'frame' then
		insert pos into stixs;
	      else
		if st.locus = 'interpret' then
		    insert pos into stixs;
		  end if;
	      end if;
	  end if;
      end for;
    
    reference <- procedure of process (Q: referenceQ)
      declare
	cm: reference;
      begin
	receive cm from Q;
	inspect st in cm.st[cm.ix] begin
	    if cm.ix <> st.position then
		cm.ix := st.position;
		cm.reply <- 'true';
	      else
		cm.reply <- 'false';
	      end if;
	  end inspect;
	return cm;
      end process;
    
    -- update all interpreted branch addresses
    call cm.references(cm.statements, stixs, reference, junk);

    return cm;
    
  end process
