-- (C) Copyright International Business Machines Corporation 16 September
-- 1991.  All Rights Reserved.
--
-- See the file USERAGREEMENT distributed with this software for full
-- terms and conditions of use.
-- SCCS Info: @(#)chtransform.d	1.3 2/8/92

chtransform: using(chdescriptors, chinternal,
    common, interpform, load, terminalIO)

  definitions
    
    counter : integer;
    operand_index_list : ordered table of integer {init};
    
    ch_statements : ordered table of ch_statement {full};
    ch_statement : record (

        opcode : opcode,                  -- from li-code
        operands : operand_index_list,    -- indexing ch_operands
        qualifier : interpform!qualifier, -- from li-code
	flow : instruction_flow,	  -- from descriptors(opcode)
        locus : execution_locus,          -- initially from descriptors(opcode)
        position : integer,     -- statement index after processing;
                                   -- initially = position in table.
        references : counter    -- incremented for each branch which
                                   -- references this statement.
      );
    
    ch_operands : ordered table of ch_operand {full};
    ch_operand : record (
        Id : operand,			-- the (dotted) identifier
        Family : data_family,		-- inferred from code
        Assignments : counter,		-- assignment + call argument count
        References : counter,		-- references to operand
        Literal : qualifier_literal	-- literal value
      );

    qualifier_family : ordered enumeration (
        'boolean', 'integer', 'real', 'string', 'none', 'variable',
        'indeterminate'
      );

    qualifier_literal : variant of qualifier_family (
        'boolean' -> boolean : boolean {init},
        'integer' -> integer : integer {init},
        'real' -> real : real {init},
        'string' -> string : charstring {init},
        'none' -> none : empty {},
        'variable' -> variable : empty {},
        'indeterminate' -> indeterminate : empty {}
      );

    cblocks : ordered table of cblock {full};
    cblock : record(
	ingress : cblock_indices,       -- entry numbers of this block
	first : integer,		-- first statement index of
					-- this block
	next : integer,			-- first statement index of
					-- next block
	statements : statement_index_list,  -- component instructions
	otherlabels : statement_indices -- statements whose references
					   -- are redirected to this cblock
      );
    
    cblock_indices : ordered table of integer {init};
    statement_index_list : ordered table of integer {init};
    
    phase1 : callmessage(
        ch : chcontrols,
        code : code,
        statements : ch_statements,
        operands : ch_operands,
	references : referencesFn
      )
    constant (references)
    exit {full}
    exception already {full(ch), init(code), init(references)};
    phase1Q : inport of phase1 {full(ch), init(code), init(references)};
    phase1Fn : outport of phase1Q;
    
    phase2 : callmessage(
        ch : chcontrols,
        cblocks : cblocks,
        statements : ch_statements,
        operands : ch_operands,
	references : referencesFn
      )
    constant (references)
    exit {full};
    phase2Q : inport of phase2
       {full(ch), init(statements), init(operands), init(references)};
    phase2Fn : outport of phase2Q;
        
    phase3 : callmessage(
        ch : chcontrols,
        cblocks : cblocks,
	statements : ch_statements,
        operands : ch_operands,
	references : referencesFn,
	lipart : prog,
	chpart : charstring	
      )
    constant (references)
    exit {full};
    phase3Q : inport of phase3 {full(ch), init(statements), init(operands),
	init(cblocks), init(references), full(lipart)};
    phase3Fn : outport of phase3Q;
            
    references : callmessage(
	st : ch_statements,
	stxs : statement_indices,
	test : referenceFn,
	result : boolean	-- incluse or of individual test results
      )
    constant(stxs, test)
    exit {full};
    referencesQ : inport of references {init(st), init(stxs), init(test)};
    referencesFn : outport of referencesQ;
    
    statement_indices : table of integer {init};

    reference : callmessage(
	st : ch_statements,
	ix : integer,
	reply : boolean
      )
    exit {full}
    minimum {init(st), init(ix)};
    referenceQ : inport of reference {init(st), init(ix)};
    referenceFn : outport of referenceQ;
        
    -- function to compile C code
    chcompile: callmessage (
      ch: chcontrols,
      progname: charstring,
      object: charstring
    )
    constant (ch, progname)
    exit {full}
    exception failure {init(ch), init(progname)};
    chcompileQ: inport of chcompile {init(ch), init(progname)};
    chcompileFn: outport of chcompileQ;
    
  end definitions
