-- (C) Copyright International Business Machines Corporation 16 September
-- 1991.  All Rights Reserved.
--
-- See the file USERAGREEMENT distributed with this software for full
-- terms and conditions of use.
-- SCCS Info: @(#)chrtoa.p	1.1 9/25/91

-- This process serves requests to convert reals into character strings.
--
-- Input is real.
--
-- Output is string.
--
-- The chermes process crtoa is called to convert each real, using a
-- common format (received initially along with the crtoa capability).
-- Special processing is necessary for integral real values, to force
-- the appearance of a decimal point in string.
--

chrtoa: using (chinternal, crtoa)
  
  process (IQ: initformatrealQ)

  declare
    icm: initformatreal;
    Q: formatrealQ;
    format: charstring;
    crtoa: ConvertRealToAsciiFn;
    cm: formatreal;

  begin
    format := "g";
    
    receive icm from IQ;
    crtoa := icm.crtoa;
    new Q;
    connect icm.rtoa to Q;
    return icm;

-- service loop

    while 'true' repeat
	receive cm from Q;
	cm.string <- crtoa(format, cm.real);
	if forall of c in cm.string
	       where((c >= '0' and c <= '9') or c = '-')
	  then
	    merge ".0" into cm.string;
	  end if;
	return cm;
      end while;

  end process
