-- (C) Copyright International Business Machines Corporation 16 September
-- 1991.  All Rights Reserved.
--
-- See the file USERAGREEMENT distributed with this software for full
-- terms and conditions of use.
-- SCCS Info: @(#)chqualifier.p	1.1 1/21/92

chqualifier : using(chencode, interpform, string)

  process(Q: encode_qualifierQ)
    
  declare
    cm: encode_qualifier;
    
    sq: interpform!qualifier;
    k: char;
    
  begin
    
    receive cm from Q;
    sq := cm.st.qualifier;
    
    block begin
	select case of sq
	  where('absent')
	    cm.string <- "00,00";
	  where('boolean')
	    reveal sq.boolean;
	    if sq.boolean then
		cm.string <- "TRUE";
	      else
		cm.string <- "FALSE";
	      end if;
	  where('integer')
	    reveal sq.integer;
	    cm.string <- cm.ch.itoa(sq.integer);
	  where('real')
	    reveal sq.real;
	    cm.string <- cm.ch.rtoa(sq.real);
	  where('string')
	    reveal sq.string;
	    new cm.string;
	    k <- 'a';
	    insert '"' into cm.string;
	    for c in sq.string[] inspect
		block begin
		    select c
		      where('"')
			insert '\' into cm.string;
		      where('\')
			insert '\' into cm.string;
		      where('*')
			if k = '/' then
			    merge "\052" into cm.string;
			    exit done;
			  end if;
		      where('/')
			if k = '*' then
			    merge "\057" into cm.string;
			    exit done;
			  end if;
		      otherwise
		      end select;
		    insert copy of c into cm.string;
		    k := c;
		  on exit (done)
		    k <- 'a';
		  end block;
	      end for;
	    insert '"' into cm.string;
	  where ('integer_pair')
	    reveal sq.integer_pair;
	    cm.string <- cm.ch.itoa(sq.integer_pair.int_one);
	    merge "," into cm.string;
	    merge cm.ch.itoa(sq.integer_pair.int_two) into cm.string;
	  where('select')
	    if cm.st.locus = 'block' then
		exit compound;
	      end if;
	    reveal sq.select;
	    new cm.string;
	    k <- '{';
	    for i in sq.select[] inspect
		insert k into cm.string;
		merge cm.ch.itoa(i) into cm.string;
		k <- ',';
	      end for;
	    insert '}' into cm.string;
	  otherwise
	    exit compound;
	  end select;
      
      on exit(compound)
	block begin
	    inspect pq in cm.pool where(pq = sq) begin
		cm.string <- cm.ch.itoa(position of pq);
	      end inspect;
	  on (NotFound)
	    cm.string <- cm.ch.itoa(size of cm.pool);
	    insert sq into cm.pool;
	  end block;
      end block;
    
    return cm;
		
  end process
