-- (C) Copyright International Business Machines Corporation 16 September
-- 1991.  All Rights Reserved.
--
-- See the file USERAGREEMENT distributed with this software for full
-- terms and conditions of use.
-- SCCS Info: @(#)chphase2.d	1.1 9/25/91

chphase2: using(chdescriptors, chinternal, chtransform, interpform)

  definitions
    
    targets : table of target {full} KEYS(index);
    target : record(
	index : integer,
	references : counter
      );
    
    serveCblocks : callmessage(
	egress : egressFn,
	reference : referenceFn
      )
    exit {full};
    serveCblocksQ : inport of serveCblocks {};
    serveCblocksFn : outport of serveCblocksQ;
    
    egress : callmessage(
	index : integer,
	references : counter,
	reply : boolean
      )
    constant(index, references)
    exit {full};
    egressQ : inport of egress {init(index), init(references)};
    egressFn : outport of egressQ;
    
    endblock : callmessage()
    exit {};
    endblockQ : inport of endblock {};
    endblockFn : outport of endblockQ;
    
    improve : callmessage(
        ch : chcontrols,
        cblocks : cblocks,
        statements : ch_statements,
        operands : ch_operands
      )
    exit {full};
    improveQ : inport of improve {full(ch), init(cblocks), 
	init(statements), init(operands)};
    improveFn : outport of improveQ;
    
  end definitions

