-- (C) Copyright International Business Machines Corporation 16 September
-- 1991.  All Rights Reserved.
--
-- See the file USERAGREEMENT distributed with this software for full
-- terms and conditions of use.
-- SCCS Info: @(#)chimprove_code.p	1.2 2/4/92

chimprove_code: using(chdescriptors, chimprove, chinternal, chphase2,
    chtransform, interpform)
linking (chimprove_cbranch, chimprove_convert, chimprove_discard,
  chimprove_eliminate1, chimprove_literal, chimprove_move, chimprove_select,
  chimprove_operations)

  process(Q: improveQ)
    
  declare
    
    cm: improve;
    
    sxs: statement_index_list;
    spx: integer;
    st: ch_statement;
    cblocks: cblocks;
    cbs: cblocks;
    cb: cblock;
    de: statement_descriptor;
    opxs: operand_index_list;
    int: integer;
    ints: select_qual;
    op: ch_operand;
    sox: integer;
    src: integer;
    dst: integer;
    opcode: opcode;
    qual: interpform!qualifier;
    lit: qualifier_literal;
    e: empty;
    i: integer;
    j: integer;
    k: counter;
    r: real;
    
    adjust: adjustFn;
    
    continue: boolean;
    eliminated: boolean;
    
    cbranch: peeperFn;
    convert: computedFn;
    discard: improverFn;
    eliminate1: computedFn;
    eliminate2: computedFn;
    literal: improverFn;
    move: peeperFn;    
    select: peeperFn;    
    
  begin
    
    receive cm from Q;
    
    adjust <- procedure of process(Q: adjustQ)
      declare
	cm: adjust;
	op: ch_operand;
      begin
	receive cm from Q;
	if cm.ox >= 0 then
	    remove op from cm.operands[cm.ox];
	    op.References <- op.References - 1;
	    if cm.as <> 'referenced' then
		op.Assignments <- op.Assignments - 1;
	      end if;
	    insert op into cm.operands at cm.ox;
	  end if;
	return cm;
      end process;
    
    cbranch <- procedure of process chimprove_cbranch;
    convert <- procedure of process chimprove_convert;
    discard <- procedure of process chimprove_discard;
    eliminate1 <- procedure of process chimprove_eliminate1;
--  eliminate2 <- procedure of process chimprove_eliminate2;
    literal <- procedure of process chimprove_literal;
    move <- procedure of process chimprove_move;
    select <- procedure of process chimprove_select;
    
    cblocks <- cm.cblocks;
    
    continue <- 'true';
    eliminated <- 'false';
    while continue repeat
	continue <- 'false';
	new cbs;
	for ccb in cblocks[] inspect
	    cb := ccb;
	    new sxs;
	    for stx in cb.statements[] inspect
		insert copy of stx into sxs;
		inspect st1 in cm.statements[stx] begin
		    de := cm.ch.descriptors[st1.opcode];
		    block begin
			select de.improve
			  where('cbranch')
			    call cbranch(cm.ch, cm.statements, cm.operands,
				sxs, adjust, continue);
			  where('convert')
			    call convert(cm.ch, cm.statements, cm.operands,
				stx, opcode, qual);
			  where('discard')
			    call discard(cm.ch, cm.statements, cm.operands,
				stx, adjust);
			  where('eliminate1')
			    call eliminate1(cm.ch, cm.statements, cm.operands,
				stx, opcode, qual);
--			  where('eliminate2')
--			    call eliminate2(cm.ch, cm.statements, cm.operands,
--				stx, opcode, qual);
			  where('literal')
			    call literal(cm.ch, cm.statements, cm.operands,
				stx, adjust);
			  where('move')
			    call move(cm.ch, cm.statements, cm.operands,
				sxs, adjust, continue);
			  where('select')
			    call select(cm.ch, cm.statements, cm.operands,
				sxs, adjust, continue);
			  otherwise -- 'null' improvement
			  end select;
		      on (computed.constant)
			remove st from cm.statements[stx];
			st.opcode <- opcode;
			dst <- st.operands[0];
			inspect opd in cm.operands[dst] begin
			    if opd.Assignments = 1 then
				remove op from cm.operands[dst];
				select case of qual
				  where('boolean')
				    reveal qual.boolean;
				    unite op.Literal.boolean
				       from copy of qual.boolean;
				  where('integer')
				    reveal qual.integer;
				    unite op.Literal.integer
				       from copy of qual.integer;
				  where('real')
				    reveal qual.real;
				    unite op.Literal.real
				       from copy of qual.real;
				  otherwise  -- should never happen
				  end select;
				insert op into cm.operands at dst;
			      end if;
			  end inspect;
			while size of st.operands > 1 repeat
			    remove i from st.operands[1];
			    call adjust('referenced', i, cm.operands);
			  end while;
			st.qualifier <- qual;
			insert st into cm.statements at stx;
			continue <- 'true';
		      on (improver.drop, peeper.drop)
			for ox in st1.operands[] inspect
			    if position of ox = 0 then
				call adjust(de.destination, ox, cm.operands);
			      else
				call adjust('referenced', ox, cm.operands);
			      end if;
			  end for;
			if st1.locus = 'escape' or st1.References <> 0 then
			    remove st from cm.statements[stx];
			    st.opcode <- 'noop';
			    new st.operands;
			    st.flow <- 'continue';
			    unite st.qualifier.empty from e;
			    insert st into cm.statements at stx;
			  else
			    remove i from ix in sxs[size of sxs - 1];
			  end if;
			continue <- 'true';
		      end block;
		  end inspect;
	      end for;
	    cb.statements <- sxs;
	    insert cb into cbs;
          end for;

	if not (eliminated or continue) then
	    call (operationsFn#(create of process chimprove_operations))
		(cm.ch, cbs, cm.statements, cm.operands, adjust, continue);
	    eliminated <- 'true';
	  end if;
	
	cblocks <- cbs;
      end while;
    
    cm.cblocks <- cblocks;
    return cm;
    
  end process
