-- (C) Copyright International Business Machines Corporation 16 September
-- 1991.  All Rights Reserved.
--
-- See the file USERAGREEMENT distributed with this software for full
-- terms and conditions of use.
-- SCCS Info: @(#)chimprove_cblocks.p	1.2 2/4/92

-- This process traverses cblocks, attempting to improve it by simplifying/
-- eliminating elements.
--
-- Input is statements and cblocks.
--
-- Both statements and cblocks may be modified.
--
-- Statements is scanned for framing statements, and a frame table is
-- constructed, including the position (label) of every statement which
-- is a target of a framing statement (block handlers, blocking select
-- targets) or is a successor of blocking statement.
--
-- Then cblocks is scanned for candidates for improvement/elimination.
-- A cblock is a candidate if it indexes precisely one statement,
-- which is either a 'noop' or a 'branch' operation.
--
-- The executable successor of the instruction is examined, and if it
-- starts a cblock, or is 'interpret'ed, the candidate is accepted.
--
-- If it starts a cblock, the ingress of the candidate's cblock is
-- merged into the ingress of the successor's cblock, effectively
-- redirecting the swicth component for the candidate.  If in addition
-- the candidate's cblock is indexed in the frame, the cblock is
-- emptied, and the statement is marked 'omit' with opcode 'escape'
-- (recognized in chupstate), since it is no longer accessible.
--
-- If it is 'interpret'ed and otherwise inaccessible, it is exchanged
-- with the candidate, which is 'omit'ed.  In addition, the cblock
-- is eliminated, by removal from cblocks.
--

chimprove_cblocks: using(chdescriptors, chimprove, chinternal, chphase2,
    chtransform, interpform)

  process(Q: improveQ)
    
  declare
    
    cm: improve;
    
    sx: integer;
    sx1: integer;
    st: ch_statement;
    frame: statement_indices;
    cblocks: cblocks;
    cb: cblock;
    cbx: integer;
    ingress: cblock_indices;
    otherlabels: statement_indices;
    qual: interpform!qualifier;
    i: integer;
    j: integer;
    k: counter;
    
  begin
    
    receive cm from Q;
    cblocks := cm.cblocks;
    
    -- Collect indices of statements which are indirectly referenced.
    new frame;
    for st1 in cm.statements[] inspect
	if st1.locus = 'block' then
	    if st1.opcode = 'select' then
		reveal st1.qualifier.select;
		for label in st1.qualifier.select[] inspect
		    insert copy of label into frame;
		  end for;
	      end if;
	    inspect ccb in cblocks where(position of st1 = ccb.first) begin
		insert copy of ccb.next into frame;
	      end inspect;
	  end if;
	if st1.opcode = 'block' then
	    reveal st1.qualifier.block;
	    for bh in st1.qualifier.block[] inspect
		insert copy of bh.label into frame;
	      end for;
	  end if;
      end for;
    
    -- clean up any redundant cblocks
    for ccb in cm.cblocks[] inspect
	inspect st1 in cm.statements[ccb.first] begin
	    if size of ccb.statements = 1 then
		if st1.opcode = 'noop' or st1.opcode = 'branch' then
		    block begin
			if st1.opcode = 'branch' then			    
			    qual := st1.qualifier;
			    reveal qual.integer;
			    dissolve qual.integer into sx;
			  else
			    sx := ccb.next;
			  end if;
			while sx <= size of cm.statements repeat
			    inspect stn in cm.statements[sx] begin
				select stn.locus
				  where('interpret')
				    if size of ccb.ingress <= 1 and
					   (stn.references = 0 or
					       st1.opcode = 'branch' and
					       stn.references = 1)
				      then
					if st1.opcode = 'branch' then
					    if sx <> ccb.next then
						exit done;
					    end if;
					end if;
					-- move 'interpret'ed statement back
					st := st1;
					i <- position of st1;
					j <- st.position;
					k <- st.references;
					st.locus <- 'omit';
					st.position := stn.position;
					st.references <- 0;
					-- replacing it by 'omit'ed statement
					insert st into cm.statements at sx + 1;
					remove st from cm.statements[sx];
					st.position <- j;
					st.references <- k;
					insert st into cm.statements at i;
					remove st from cm.statements[i + 1];
					cbx <- position of tcb in cblocks
					   where(tcb.first = ccb.first);
					-- just throw away the cblock
					remove cb from cblocks[cbx];
				      end if;
				    exit done;
				  where('omit')
				    sx <- sx + 1;
				  where('ccode')  -- 'ccode' ??
				    exit done;
				  otherwise -- 'escape' or 'block'
				    -- successor is a cblock
				    ingress := ccb.ingress;
				    otherlabels := ccb.otherlabels;
				    cbx <- position of tcb in cblocks
				       where(tcb.first = ccb.first);
				    remove cb from cblocks[cbx];
				    -- This block is no longer accessed via ip.
				    new cb.ingress;
				    new cb.otherlabels;
				    sx1 := cb.first;
				    if exists of label in frame
					   where(label = sx1) then
					remove st from cm.statements[sx1];
					-- Its no longer accessible at all.
					st.locus <- 'omit';
					-- Indicate empty cblock!
					st.opcode <- 'escape';
					insert st into cm.statements at sx1;
					new cb.statements;
					insert sx1 into otherlabels;
				      end if;
				    insert cb into cblocks at cbx;
				    cbx <- position of tcb in cblocks
				       where(tcb.first = sx);
				    remove cb from cblocks[cbx];
				    -- keep the primary index last
				    merge ingress into cb.ingress at 0;
				    merge otherlabels into cb.otherlabels;
				    insert cb into cblocks at cbx;
				    exit done;
				  end select;
			      end inspect;
			  end while;
		      on exit(done)
		      end block;
		  end if;
	      end if;
	  end inspect;
      end for;
    cm.cblocks <- cblocks;
    
    return cm;
    
  end process
