-- (C) Copyright International Business Machines Corporation 16 September
-- 1991.  All Rights Reserved.
--
-- See the file USERAGREEMENT distributed with this software for full
-- terms and conditions of use.
-- SCCS Info: @(#)chassign.p	1.1 1/21/92

-- This process records assignments for phase1.
--
-- Input is a statement, an assignment enumeration variable destination
-- and a table of operand indices, reveals (initially empty).
--
-- Modifies operands and reveals. 
--
-- If desination is 'assigned' or 'modified' increment Assigned for the
-- zeroth argument of the statement.
--
--   If this is the first assignment of the operand and the statement is
--   a literal assignment, unite the Literal value of the operand with
--   the value of the assigned constant.
--
-- If destination is 'referenced' two operations are of interest -
-- call and reveal.
--
--   For call statement, increment Assigned by 1 for every operand except
--   the zeroth.
--
--   For reveal statement, if this is not the first reveal of the operand
--   increment its Assigned by 1.  The decision is made with the aid of
--   the auxiliary table, reveals, which is passed with every call (it
--   could be a state variable of an assign server instead).
--

chassign: using(chphase1, chtransform, interpform)

  process(Q: assignQ)
    
  declare
    
    cm: assign;
    
    opcode: opcode;
    statement: ch_statement;
    rands: operand_index_list;
    dest: integer;
    rand: integer;
    qual: interpform!qualifier;
    chop: ch_operand;
    arg: ch_operand;
    operand: operand;
    
    first: boolean;
    e: empty;
    i: integer;
    
  begin
       
    receive cm from Q;
    
    statement := cm.statement;
    opcode <- statement.opcode;
    rands <- statement.operands;
    remove dest from rands[0];
    
    if cm.destination = 'referenced' then
	
	if opcode = 'call' then
	    while size of rands <> 0 repeat
		remove rand from rands[0];
		remove arg from cm.operands[rand];
		-- if argument is returned and not constant !?
		arg.Assignments <- arg.Assignments + 1;
		-- an outport isn't a base for variants
		insert arg into cm.operands at rand;
	      end while;
	  else
	    if opcode = 'reveal' then
		block begin
		    insert dest into cm.reveals;
		  on (DuplicateKey)
		    -- 'reveal'ed twice - count as extra assignment
		    remove arg from cm.operands[dest];
		    arg.Assignments <- arg.Assignments + 1;
		    insert arg into cm.operands at dest;
		  end block;
	      end if;
	  end if;
	
      else
	
	remove chop from cm.operands[dest];
	chop.Assignments := chop.Assignments + 1;
	
	block
	  begin
	
	    first <- (case of chop.Literal = 'none');
	    qual <- statement.qualifier;
	    select

	      where(opcode = 'boolean')
		if first then
		    reveal qual.boolean;
		    unite chop.Literal.boolean from copy of qual.boolean;
		    exit ok;
		  end if;

	      where(opcode = 'ilit' or
		       opcode = 'enum_lit' or
		       opcode = 'ordenum_lit')
		if first then
		    reveal qual.integer;
		    unite chop.Literal.integer from copy of qual.integer;
		    exit ok;
		  end if;

	      where(opcode = 'rlit')
		if first then
		    reveal qual.real;
		    unite chop.Literal.real from copy of qual.real;
		    exit ok;
		  end if;

	      where(opcode = 'chs_lit')
		if first then
		    reveal qual.string;
		    unite chop.Literal.string from copy of qual.string;
		    exit ok;
		  end if;
	    
	      otherwise
	    
	      end select;
	
	    unite chop.Literal.variable from e;
	  
	  on exit(ok)
	  end block;
	
	insert chop into cm.operands at dest;

      end if;
    
    return cm;
    
  end process
