/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* File: rpcserver.ch */
/* Author: David F. Bacon */
#ifndef lint
static char sccsinfo[] = "@(#)rpcserver.ch	1.13 8/28/91";
#endif

#include "sysdep.h"

#ifdef FDSETS

#define FDSET_T fd_set

#ifdef sgi
#define FDSET_NAME svc_fds
#define FDSVC_GETREQ svc_getreq
#else
#define FDSET_NAME svc_fdset
#define FDSVC_GETREQ svc_getreqset
#endif

#define FDSET_SIZE getdtablesize()
#define FDTESTBIT(fd,rfds) (FD_ISSET(fd, &(rfds)))
#define FDPASSARG(x) (&(x))

#else

#define FDSET_T int
#define FDSET_NAME svc_fds
#define FDSET_SIZE 32
#define FDSVC_GETREQ svc_getreq
#define FDTESTBIT(fd,rfds) (((1 << (fd)) & (rfds)) != 0)
#define FDPASSARG(x) (x)

#endif


#ifdef _IBMR2
#  include "asyncrpc.h"
#  include "rpc.h"
#else
#  include "rpc.h"
#  include "asyncrpc.h"
#endif

#include "distrib.h"

#define IP_INIT 0
#define IP_INITSERVE 1
#define IP_SERVE 2

#define RPCDEBUGLEVEL 17
#define RPCBUG if (debug_level(RPCDEBUGLEVEL))

extern int errno;

#if ! ( defined(_AIX) || defined(sgi) || defined(hpux) )
extern FDSET_T FDSET_NAME;
#endif

extern u_long interpno;
extern object *Linkport;
static int rpcsock;

CProc(C_set_linking_port)
{
    objectp Initp;
    lobject(Callmsg);


    Initp = & current->ep.c->initport;
    (void) copy(Callmsg, Bottom);
    if (c_receive(Callmsg, Initp) is SUCCESS) {
	(void) discard(Initp);	/* only accept one request */
	
	if (not is_bottom(Linkport)) {
	    if (debug_level(1)) 
	      nilerror("C_set_linking_port", 
		       "Attempt to reset linking port");
	    c_discard(sched, Callmsg);
	}
	else {
	    move(Linkport, Callmsg@setlinkingport__outport);
	    c_return(sched, Callmsg);
	}

	sched->kill(sched, current);
    }
    else if (c_disconn(Initp)) {
      c_discard(sched, Initp);
      c_endprocess(sched, current);
    }
    else
      c_wait(sched, current, Initp);
}



CProc(C_start_network)
{
    void abort_nili();

    extern interpname localaddr;

    lobject(Callmsg);
    objectp Initp;


    Initp = & current->ep.c->initport;

    switch (current->ip) {

      case IP_INIT: {
	  current->ip = IP_INITSERVE;
	  c_wait(sched, current, Initp);
	  break;
      }

      case IP_INITSERVE: {
	  void hermesproc_rpcserver();

	  SVCXPRT *transp = NULL;


	  set_bottom(Callmsg);
	  if (c_receive(Callmsg, Initp) == FAILURE) {
	    if (c_disconn(Initp)) {
	      c_discard(sched, Initp);
	      c_endprocess(sched, current);
	    }
	    else
	      c_wait(sched, current, Initp);
	    break;
	  }
	  
	  if (interpno is 0) {
	      interpno = (u_long) integerval(Callmsg@startnetwork__interpno);
	      localaddr.number = interpno;
	  }
	  else
	    goto cleanup;

	  (void) pmap_unset(HERMESPROG, interpno);
	  
	  transp = svcatcp_create(RPC_ANYSOCK, 0, 0);
	  if (transp is NULL) {
	      if (debug_level(3))
		nilerror("C_start_network", "cannot create tcp service");
	      goto cleanup;
	  }
	  
	  rpcsock = transp->xp_sock; /* squirrel away socket handle */

	  if (not svc_register(transp, HERMESPROG, interpno, 
			       hermesproc_rpcserver, IPPROTO_TCP)) {
	      if (debug_level(3))
		nilerror("C_start_network",
			 "unable to register (HERMESPROG, interpno, tcp).\n");
	      goto cleanup;
	  }
	  
	  fd_wait(current, rpcsock, TRUE, FALSE, sched);
				/* tell signalio handler we are waiting on */
				/*  reads (TRUE), but not writes (FALSE). */
	  
	  /* sigio_flag = TRUE ?? */
	  current->ip = IP_SERVE;
	  c_return(sched, Callmsg);

	  break;

	cleanup: {
	    if (transp)
	      svc_destroy(transp);
	    c_discard(sched, Callmsg);
	    sched->kill(sched, current);
	    break;
	}
      }

      case IP_SERVE: {
	  FDSET_T read_fds;
	  int j;
	  flag pending;
	  static struct timeval TIMEOUT = { 0, 0 };
	  extern schedblock *rpcsched;


	  pending = TRUE;

	  RPCBUG {
	      fprintf(stderr, "in rpc handler.\n");
	      (void) fflush(stderr);
	  }

	  while (pending) {
	      read_fds = FDSET_NAME;
	      switch (select(FDSET_SIZE, &read_fds, (FDSET_T *) NULL,
			     (FDSET_T *) NULL, &TIMEOUT)) {
		case -1: {
		    if (errno == EINTR)
		      continue;
		    nilperror("C_start_network", "select failed");
		    abort_nili("C_start_network");
		    /*NOTREACHED*/
		}
		case 0: {
		    pending = FALSE;
		    break;
		}
		default: {
		    rpcsched = sched;
				/* put this here so that rpc routines can */
				/*  pick it up, since there is no way to */
				/*  communicate values to them that don't */
				/*  come over the net (sigh). */
		    FDSVC_GETREQ(FDPASSARG(read_fds));
				/* this call may change the set of file */
				/*  descriptors rpc needs to know about... */
		}
	      }
	  }

	  fd_wait(current, rpcsock, TRUE, FALSE, sched);

	  RPCBUG {
	      (void) fprintf(stderr, "Waiting on primary handle %d [ ",
			     rpcsock);
	  }

	  read_fds = FDSET_NAME;
	  for (j=0; j<FD_SETSIZE; j++) 
	    if (FDTESTBIT(j,read_fds) and j isnt rpcsock) {
		fd_wait(current, j, TRUE, FALSE, sched);
		RPCBUG {
		    (void) fprintf(stderr, "%d ", j);
		}
	    }

	  RPCBUG {
	      (void) fprintf(stderr, "].\n");
	      (void) fflush(stderr);
	  }

	  break;
	      
      } /* case IP_SERVE */

    } /* switch (current->ip) */
}



static void
hermesproc_rpcserver(rqstp, transp)
struct svc_req *rqstp;
SVCXPRT *transp;
{
    xdr_status hxdr_hmsg_buf();
    void recvrpc();
    hmsg_buf argument;

    
    switch (rqstp->rq_proc) {
      case NULLPROC:
	(void)svc_sendreply(transp, xdr_void, (char *)NULL);
	return;
	
      case HERMESPROC:
	bzero((char *)&argument, sizeof(argument));
	if (not svc_getargs(transp, hxdr_hmsg_buf, &argument)) {
	    svcerr_decode(transp);
	    return;
	}
	recvrpc(&argument);
	return;
	
      default:
	svcerr_noproc(transp);
	return;
    }
}
