/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
#define _BSD 43

#include <assert.h>
#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#ifdef _IBMR2
#  undef EWOULDBLOCK
#  define EWOULDBLOCK EAGAIN
#endif
#include <signal.h>
#include <sys/types.h>
#include <sys/time.h>

#include "cfunc.h"
#include "fdhandlers.h"
#include "storage.h"
#undef read
#undef write

#include "fdhandlers.cd"

extern int errno;

#define IP_INIT		0
#define IP_SERVE	1
#define IP_CONTINUE	2
#define IP_DEAD		3  

void abort_nili();

extern int fd_close[FD_SETSIZE];
#define BUFSIZE 256

CProc(C_fdread)
{
  void re_finalize();

  FDREADDATA *ep = (FDREADDATA *) (current->ep.c->data);
  objectp initp = & current->ep.c->initport;
  objectp initm = & ep->initmessage;
  objectp callp = & ep->callport;
  objectp callm = & ep->callmessage;
  int fd = ep->fd;
  char buffer[BUFSIZE];
  int success;

  switch (current->ip)
    {
    case IP_INIT:
      /* Initialize the server */
      (void) copy(initm,Bottom);
      if (c_receive(initm,initp) is FAILURE)
	if (c_disconn(initp)) {
	  c_discard(sched, initp);
	  c_endprocess(sched, current);
	}
	else
	  c_wait(sched, current, initp);
      else
	{
	  if ((c_new_inport(callp) is FAILURE)||
	      (c_connect(initm@readinit__read,callp) is FAILURE)) {
	      nilerror("C_fdread","no connection");
	      abort_nili("C_fdread");
	  }
	  ep->fd = integerval(initm@readinit__in);
	  current->ip = IP_SERVE;
	  c_wait(sched, current, callp);
	  c_return(sched, initm);
	  /* Shut down init port */
	  c_discard(sched, initp);
	}
      break;
    case IP_SERVE:
      /* Service a callmessage on the call port */
      (void) copy(callm,Bottom);
      if (c_receive(callm,callp) is FAILURE) {
	if (c_disconn(callp)) {
	  c_discard(sched, callp);
	  c_endprocess(sched, current);
	}
	else
	  c_wait(sched, current, callp);
	break;
      }
    case IP_CONTINUE:
      if (fd_close[fd])
	{
#ifdef SIGNALIO_DEBUG
	  printf("*Read shutdown\n");  (void) fflush(stdout);
#endif
	  /* Shutdown */
	  close(fd);
	  re_finalize(callm, F_DISCARD, sched);
	  /* Die */
	  re_finalize(callp, F_DISCARD, sched);
	  { freemain(ep,sizeof(FDREADDATA)); }
	  current->ip = IP_DEAD;
	  sched->kill(sched, current);
	  break;
	}
      success = read(fd,buffer,sizeof(buffer)-1);
      if ((success==0)|| /* EOF */
	  ((success==-1)&&(errno!=EWOULDBLOCK))) /* General error */
	{
	  /* Error return */
#ifdef SIGNALIO_DEBUG
	  printf("*Read on [%d] returns error.\n",fd); (void) fflush(stdout);
#endif
	  if (!chs_lit(callm@read__data,"Read error.")) {
	      nilerror("C_fdread","out of memory");
	      abort_nili("C_fdread");
	  }
	  (void) h_boolean(callm@read__success,0);
	  c_wait(sched, current, callp);
	  c_return(sched, callm);
	  current->ip = IP_SERVE;
	}
      else if ((success==-1)&&(errno==EWOULDBLOCK))
	{
	  /* Data not ready */
	  /* On wakeup, continue */
	  current->ip = IP_CONTINUE;
	  /* Go to sleep */
	  fd_wait(current,fd,1,0,sched);
	}
      else
	{
	  /* success number of char's read */
	  buffer[success] = '\0';
#ifdef SIGNALIO_DEBUG
	  printf("*Read on [%d] returns \"%s\".\n",fd,buffer); (void) fflush(stdout);
#endif
	  if (!chs_lit(callm@read__data,buffer)) {
	      nilerror("C_fdread","out of memory");
	      abort_nili("C_fdread");
	  }
	  (void) h_boolean(callm@read__success,1);
	  c_wait(sched, current, callp);
	  c_return(sched, callm);
	  current->ip = IP_SERVE;
	}
      break;
    default:
      nilerror("C_fdread","bad state");
      abort_nili("C_fdread");
    }
  (void) fflush(stdout);
}

CProc(C_fdwrite)
{
  void re_finalize();
  
  FDWRITEDATA *ep = (FDWRITEDATA *) (current->ep.c->data);
  objectp initp = & current->ep.c->initport;
  objectp initm = & ep->initmessage;
  objectp callp = & ep->callport;
  objectp callm = & ep->callmessage;
  int fd = ep->fd;
  char *buffer;
  int count;
  int success;

  switch (current->ip)
    {
    case IP_INIT:
      /* Initialize the server */
      (void) copy(initm,Bottom);
      if (c_receive(initm,initp) is FAILURE)
	if (c_disconn(initp)) {
	  c_discard(sched, initp);
	  c_endprocess(sched, current);
	}
	else
	  c_wait(sched, current, initp);
      else
	{
	  if ((c_new_inport(callp) is FAILURE)||
	      (c_connect(initm@writeinit__write,callp) is FAILURE)) {
	      nilerror("C_fdwrite","no connection");
	      abort_nili("C_fdwrite");
	  }
	  ep->fd = integerval(initm@writeinit__out);
	  current->ip = IP_SERVE;
	  c_wait(sched, current, callp);
	  c_return(sched, initm);
	  /* Shut down init port */
	  c_discard(sched, initp);
	}
      break;
    case IP_SERVE:
      /* Service a callmessage on the call port */
      (void) copy(callm,Bottom);
      if (c_receive(callm,callp) is FAILURE) {
	if (c_disconn(callp)) {
	  c_discard(sched, callp);
	  c_endprocess(sched, current);
	}
	else
	  c_wait(sched, current, callp);
	break;
      }
      ep->buffer = stringval(callm@write__data);
      ep->count = strlen(ep->buffer);
    case IP_CONTINUE:
      if (fd_close[fd])
	{
#ifdef SIGNALIO_DEBUG
	  printf("*Write shutdown\n");  (void) fflush(stdout);
#endif
	  /* Shutdown */
	  close(fd);
	  /* Die */
	  re_finalize(callm, F_DISCARD, sched);
	  re_finalize(callp, F_DISCARD, sched);
	  { freemain(ep,sizeof(FDWRITEDATA)); }
	  current->ip = IP_DEAD;
	  sched->kill(sched, current);
	  break;
	}
      buffer = ep->buffer;
      count = ep->count;
      success = write(fd,buffer,count);
      if ((success==0)|| /* EOF */
	  ((success==-1)&&(errno!=EWOULDBLOCK))) /* General error */
	{
	  /* Error return */
#ifdef SIGNALIO_DEBUG
	  printf("*Write of \"%s\" on [%d] returns error.\n",buffer,fd); (void) fflush(stdout);
#endif
	  (void) h_boolean(callm@write__success,0);
	  c_wait(sched, current, callp);
	  c_return(sched, callm);
	  current->ip = IP_SERVE;
	}
      else if ((success==-1)&&(errno==EWOULDBLOCK))
	{
	  /* Data not ready */
	  /* On wakeup, continue */
	  current->ip = IP_CONTINUE;
	  /* Go to sleep */
	  fd_wait(current,fd,0,1,sched);
	}
      else
	{
	  /* success number of char's written */
	  if (success==count)
	    {
#ifdef SIGNALIO_DEBUG
	      printf("*Write of \"%s\" on [%d] successful.\n",buffer,fd); (void) fflush(stdout);
#endif
	      (void) h_boolean(callm@write__success,1);
	      c_wait(sched, current, callp);
	      c_return(sched, callm);
	      current->ip = IP_SERVE;
	    }
	  else
	    {
#ifdef SIGNALIO_DEBUG
	      printf("*Write of \"%s\" on [%d] writes %d of %d.\n",buffer,fd,success,count);
	      (void) fflush(stdout);
#endif
	      ep->buffer += success;
	      ep->count -= success;
	      current->ip = IP_CONTINUE;
	    }
	}
      break;
    default:
      nilerror("C_fdwrite","bad state");
      abort_nili("C_fdwrite");
    }
  (void) fflush(stdout);
}

CProc(C_fdclose)
{
  void re_finalize();

  FDCLOSEDATA *ep = (FDCLOSEDATA *) (current->ep.c->data);
  objectp initp = & current->ep.c->initport;
  objectp initm = & ep->initmessage;
  objectp callp = & ep->callport;
  objectp callm = & ep->callmessage;
  int *fd = ep->fd;

  switch (current->ip)
    {
    case IP_INIT:
      /* Initialize the server */
      (void) copy(initm,Bottom);
      if (c_receive(initm,initp) is FAILURE)
	if (c_disconn(initp)) {
	  c_discard(sched, initp);
	  c_endprocess(sched, current);
	}
	else
	  c_wait(sched, current, initp);
      else
	{
	  if ((c_new_inport(callp) is FAILURE)||
	      (c_connect(initm@closeinit__close,callp) is FAILURE)) {
	      nilerror("C_fdclose","no connection");
	      abort_nili("C_fdclose");
	  }
	  fd[0] = integerval(initm@closeinit__in);
	  fd[1] = integerval(initm@closeinit__out);
	  fd_close[fd[0]] = 0;
	  fd_close[fd[1]] = 0;
	  current->ip = IP_SERVE;
	  c_wait(sched, current, callp);
	  c_return(sched, initm);
	  /* Shut down init port */
	  c_discard(sched,initp);
	}
      break;
    case IP_SERVE:
      /* Service a callmessage on the call port */
      (void) copy(callm,Bottom);
      if (c_receive(callm,callp) is FAILURE) {
	if (c_disconn(callp)) {
	  c_discard(sched, callp);
	  c_endprocess(sched, current);
	}
	break;
      }
    case IP_CONTINUE:
#ifdef SIGNALIO_DEBUG
      printf("*Close shutdown\n");  (void) fflush(stdout);
#endif
      fd_close[fd[0]] = 1;
      fd_close[fd[1]] = 1;
      /* Shutdown */
      c_return(sched, callm);
      /* Die */
      re_finalize(callp, F_DISCARD, sched);
      { freemain(ep,sizeof(FDCLOSEDATA)); }
      current->ip = IP_DEAD;
      sched->kill(sched, current);
      break;
    default:
      nilerror("C_fdclose","bad state");
      abort_nili("C_fdclose");
    }
  (void) fflush(stdout);
}

